/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.mapping;

import com.evrythng.java.wrapper.mapping.Deserializer;
import com.evrythng.java.wrapper.util.JSONUtils;
import com.evrythng.thng.resource.model.store.BatchPopulatingTask;
import com.evrythng.thng.resource.model.store.ShortIdGenerationTask;
import com.evrythng.thng.resource.model.store.TaskOnBatch;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class TaskResultDeserializer
extends Deserializer<TaskOnBatch.BaseTaskResult> {
    public TaskResultDeserializer() {
        super(TaskOnBatch.BaseTaskResult.class);
    }

    public TaskOnBatch.BaseTaskResult deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        ObjectMapper mapper = JSONUtils.OBJECT_MAPPER;
        JsonNode node = (JsonNode)mapper.readTree(jp);
        JsonNode typeNode = node.get("type");
        if (typeNode == null) {
            throw new JsonMappingException("Cannot deserialize task result without type field");
        }
        String typeRaw = (String)this.getFieldValue(typeNode);
        Class<? extends TaskOnBatch.BaseTaskResult> subtypeClass = this.classForType(TaskOnBatch.BaseTaskResult.Type.valueOf((String)typeRaw.toUpperCase()));
        return (TaskOnBatch.BaseTaskResult)mapper.readValue(node.toString(), subtypeClass);
    }

    private Class<? extends TaskOnBatch.BaseTaskResult> classForType(TaskOnBatch.BaseTaskResult.Type type) {
        switch (type) {
            case POPULATING: {
                return BatchPopulatingTask.Result.class;
            }
            case SHORT_ID_GENERATION: {
                return ShortIdGenerationTask.Result.class;
            }
            case ERROR: {
                return TaskOnBatch.ErrorTaskResult.class;
            }
        }
        throw new IllegalArgumentException("Unsupported task result type: " + type);
    }
}

