/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.core.api.AcceptedResourceResponse;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.java.wrapper.mapping.EvrythngJacksonModule;
import com.evrythng.java.wrapper.service.LogsListReference;
import com.evrythng.thng.resource.model.store.action.jobs.creation.ActionJob;
import com.evrythng.thng.resource.model.store.jobs.JobLogEntry;
import com.evrythng.thng.resource.model.store.jobs.NewStatus;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.regex.Pattern;

public class ActionJobsService
extends EvrythngServiceBase {
    private static final String PATH = "/jobs/actions";
    private static final String SINGLE_PATH = "/jobs/actions/%s";
    private static final String LOG_ENTRIES_PATH = "/jobs/actions/%s/logs";
    public static final Pattern ID_LOCATION_PATTERN = Pattern.compile(".*/([^/]*)$");

    public ActionJobsService(ApiManager apiManager, EvrythngJacksonModule module) {
        super(apiManager);
    }

    public EvrythngApiBuilder.Builder<List<ActionJob<?>>> reader() throws EvrythngClientException {
        return this.get(PATH, ListReference.instance());
    }

    public EvrythngApiBuilder.Builder<ActionJob<?>> reader(String jobId) throws EvrythngClientException {
        return this.get(String.format(SINGLE_PATH, jobId), Reference.instance());
    }

    public EvrythngApiBuilder.Builder<AcceptedResourceResponse> creator(ActionJob<?> job) throws EvrythngClientException {
        return this.postAsynchronously(PATH, job, ID_LOCATION_PATTERN);
    }

    public EvrythngApiBuilder.Builder<List<JobLogEntry>> logsReader(String jobId) throws EvrythngClientException {
        return this.get(String.format(LOG_ENTRIES_PATH, jobId), LogsListReference.instance());
    }

    public static interface OnActionJobExecuted {
        public void apply(NewStatus var1);
    }

    private static final class Reference
    extends TypeReference<ActionJob<?>> {
        private static final Reference INSTANCE = new Reference();

        private static Reference instance() {
            return INSTANCE;
        }

        private Reference() {
        }
    }

    private static final class ListReference
    extends TypeReference<List<ActionJob<?>>> {
        private static final ListReference INSTANCE = new ListReference();

        private static ListReference instance() {
            return INSTANCE;
        }

        private ListReference() {
        }
    }
}

