/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.thng.resource.model.store.File;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesService
extends EvrythngServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger(FilesService.class);
    private static final String PATH_FILES = "/files";
    private static final String PATH_FILES_BY_ID = "/files/%s";

    public FilesService(ApiManager apiManager) {
        super(apiManager);
    }

    public File createFileRecordWithUploadUrl(String fileName, String fileType, boolean privateAccess, String ... tags) {
        File file = new File();
        file.setName(fileName);
        file.setType(fileType);
        file.setPrivateAccess(Boolean.valueOf(privateAccess));
        if (tags != null && ArrayUtils.isNotEmpty((Object[])tags)) {
            file.setTags(Arrays.asList(tags));
        }
        return this.fileCreator(file).execute();
    }

    public File findFileById(String id) {
        return this.fileReader(id).execute();
    }

    public boolean deleteFileById(String id) {
        return this.fileDeleter(id).execute();
    }

    public List<File> findFilesByFilter(String filter) {
        return this.filesReader(filter).execute();
    }

    public EvrythngApiBuilder.Builder<File> fileCreator(File file) {
        return this.post(PATH_FILES, file, new TypeReference<File>(){});
    }

    public EvrythngApiBuilder.Builder<File> fileReader(String id) {
        return this.get(String.format(PATH_FILES_BY_ID, id), new TypeReference<File>(){});
    }

    public EvrythngApiBuilder.Builder<List<File>> filesReader(String filter) {
        return this.get(PATH_FILES, new TypeReference<List<File>>(){}).filter(filter);
    }

    public EvrythngApiBuilder.Builder<Boolean> fileDeleter(String id) {
        return this.delete(String.format(PATH_FILES_BY_ID, id));
    }
}

