/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.commons.domain.SortOrder;
import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.java.wrapper.mapping.ActionDeserializer;
import com.evrythng.java.wrapper.mapping.EvrythngJacksonModule;
import com.evrythng.thng.resource.model.store.BooleanProperty;
import com.evrythng.thng.resource.model.store.NumberProperty;
import com.evrythng.thng.resource.model.store.Product;
import com.evrythng.thng.resource.model.store.Property;
import com.evrythng.thng.resource.model.store.Redirector;
import com.evrythng.thng.resource.model.store.StringProperty;
import com.evrythng.thng.resource.model.store.action.Action;
import com.evrythng.thng.resource.model.store.action.CustomAction;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.pcollections.PVector;

public class ProductService
extends EvrythngServiceBase {
    public static final String PATH_PRODUCTS = "/products";
    public static final String PATH_PRODUCT = "/products/%s";
    public static final String PATH_PRODUCT_PROPERTIES = "/products/%s/properties";
    public static final String PATH_PRODUCT_PROPERTY = "/products/%s/properties/%s";
    public static final String PATH_PRODUCT_REDIRECTOR = "/products/%s/redirector";
    public static final String PATH_PRODUCT_REDIRECTOR_QR = "/products/%s/redirector/qr";
    public static final String PATH_PRODUCT_ACTIONS = "/products/%s/actions";
    public static final String PATH_PRODUCT_ALL_ACTIONS = "/products/%s/actions/all";
    public static final String PATH_PRODUCT_ALL_ACTION = "/products/%s/actions/all/%s";
    public static final String PATH_PRODUCT_TYPED_ACTIONS = "/products/%s/actions/%s";
    public static final String PATH_PRODUCT_TYPED_ACTION = "/products/%s/actions/%s/%s";
    protected ActionDeserializer deserializer;

    public ProductService(ApiManager apiManager, EvrythngJacksonModule evrythngJacksonModule) {
        super(apiManager);
        this.deserializer = evrythngJacksonModule.getActionDeserializer();
    }

    public EvrythngApiBuilder.Builder<Product> productCreator(Product product) throws EvrythngClientException {
        return this.post(PATH_PRODUCTS, product, new TypeReference<Product>(){});
    }

    public final EvrythngApiBuilder.Builder<Iterator<PVector<Product>>> iterator() throws EvrythngClientException {
        return this.iterator(PATH_PRODUCTS, new TypeReference<List<Product>>(){});
    }

    public EvrythngApiBuilder.Builder<Product> productReader(String productId) throws EvrythngClientException {
        return this.get(String.format(PATH_PRODUCT, productId), new TypeReference<Product>(){});
    }

    public EvrythngApiBuilder.Builder<Long> productsUpdater(Product product) throws EvrythngClientException {
        return this.putMultiple(PATH_PRODUCTS, product);
    }

    public EvrythngApiBuilder.Builder<Product> productUpdater(String productId, Product product) throws EvrythngClientException {
        return this.put(String.format(PATH_PRODUCT, productId), product, new TypeReference<Product>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> productDeleter(String productId) throws EvrythngClientException {
        return this.delete(String.format(PATH_PRODUCT, productId));
    }

    public EvrythngApiBuilder.Builder<Long> productsDeleter() throws EvrythngClientException {
        return this.deleteMultiple(PATH_PRODUCTS);
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertiesCreator(String productId, List<Property<?>> properties) throws EvrythngClientException {
        return this.put(String.format(PATH_PRODUCT_PROPERTIES, productId), properties, new TypeReference<List<Property<?>>>(){});
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertiesReader(String productId) throws EvrythngClientException {
        return this.get(String.format(PATH_PRODUCT_PROPERTIES, productId), new TypeReference<List<Property<?>>>(){});
    }

    public final EvrythngApiBuilder.Builder<Iterator<PVector<Property<?>>>> propertiesIterator(String productId, String key) throws EvrythngClientException {
        return this.iterator(String.format(PATH_PRODUCT_PROPERTY, productId, key), new TypeReference<List<Property<?>>>(){}).sortOrder(SortOrder.descending());
    }

    public EvrythngApiBuilder.Builder<Boolean> propertiesDeleter(String productId) throws EvrythngClientException {
        return this.delete(String.format(PATH_PRODUCT_PROPERTIES, productId));
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertyReader(String productId, String key) throws EvrythngClientException {
        return this.get(String.format(PATH_PRODUCT_PROPERTY, productId, key), new TypeReference<List<Property<?>>>(){});
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertyUpdater(String productId, String key, Property<?> update) throws EvrythngClientException {
        return this.put(String.format(PATH_PRODUCT_PROPERTY, productId, key), Collections.singletonList(update), new TypeReference<List<Property<?>>>(){});
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertyUpdater(String productId, String key, String value, Long timestamp) throws EvrythngClientException {
        return this.put(String.format(PATH_PRODUCT_PROPERTY, productId, key), Collections.singletonList(new StringProperty(null, value, timestamp)), new TypeReference<List<Property<?>>>(){});
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertyUpdater(String productId, String key, Number value, Long timestamp) throws EvrythngClientException {
        return this.put(String.format(PATH_PRODUCT_PROPERTY, productId, key), Collections.singletonList(new NumberProperty(null, Double.valueOf(value.doubleValue()), timestamp)), new TypeReference<List<Property<?>>>(){});
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertyUpdater(String productId, String key, Boolean value, Long timestamp) throws EvrythngClientException {
        return this.put(String.format(PATH_PRODUCT_PROPERTY, productId, key), Collections.singletonList(new BooleanProperty(null, value, timestamp)), new TypeReference<List<Property<?>>>(){});
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertyUpdater(String thngId, String key, String value) throws EvrythngClientException {
        return this.propertyUpdater(thngId, key, value, null);
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertyUpdater(String thngId, String key, Number value) throws EvrythngClientException {
        return this.propertyUpdater(thngId, key, value, null);
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertyUpdater(String thngId, String key, Boolean value) throws EvrythngClientException {
        return this.propertyUpdater(thngId, key, value, null);
    }

    public EvrythngApiBuilder.Builder<Boolean> propertyDeleter(String productId, String key) throws EvrythngClientException {
        return this.delete(String.format(PATH_PRODUCT_PROPERTY, productId, key));
    }

    public EvrythngApiBuilder.Builder<Redirector> redirectorCreator(String productId, Redirector redirection) throws EvrythngClientException {
        return this.post(String.format(PATH_PRODUCT_REDIRECTOR, productId), redirection, new TypeReference<Redirector>(){});
    }

    public EvrythngApiBuilder.Builder<Redirector> redirectorReader(String productId) throws EvrythngClientException {
        return this.get(String.format(PATH_PRODUCT_REDIRECTOR, productId), new TypeReference<Redirector>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> redirectorDeleter(String productId) throws EvrythngClientException {
        return this.delete(String.format(PATH_PRODUCT_REDIRECTOR, productId));
    }

    public EvrythngApiBuilder.Builder<Redirector> redirectorUpdater(String productId, Redirector redirection) throws EvrythngClientException {
        return this.put(String.format(PATH_PRODUCT_REDIRECTOR, productId), redirection, new TypeReference<Redirector>(){});
    }

    public <T extends Action> EvrythngApiBuilder.Builder<T> actionCreator(String productId, T action) throws EvrythngClientException {
        return this.post(String.format(PATH_PRODUCT_TYPED_ACTIONS, productId, action.getType()), action, new TypeReference<Action>(){});
    }

    public EvrythngApiBuilder.Builder<Action> actionAllCreator(String productId, Action action) throws EvrythngClientException {
        return this.post(String.format(PATH_PRODUCT_ALL_ACTIONS, productId), action, new TypeReference<Action>(){});
    }

    public <T extends Action> EvrythngApiBuilder.Builder<T> actionReader(String productId, Class<T> actionClass, String actionId) throws EvrythngClientException {
        String type = this.getType(actionClass);
        return this.get(String.format(PATH_PRODUCT_TYPED_ACTION, productId, type, actionId), new TypeReference<Action>(){});
    }

    public EvrythngApiBuilder.Builder<CustomAction> actionReader(String productId, String customType, String actionId) throws EvrythngClientException {
        this.checkCustomType(customType);
        return this.get(String.format(PATH_PRODUCT_TYPED_ACTION, productId, customType, actionId), new TypeReference<CustomAction>(){});
    }

    public EvrythngApiBuilder.Builder<Action> actionReader(String productId, String actionId) throws EvrythngClientException {
        return this.get(String.format(PATH_PRODUCT_ALL_ACTION, productId, actionId), new TypeReference<Action>(){});
    }

    public EvrythngApiBuilder.Builder<List<Action>> actionsReader(String productId) throws EvrythngClientException {
        return this.get(String.format(PATH_PRODUCT_ALL_ACTIONS, productId), new TypeReference<List<Action>>(){});
    }

    public <T extends Action> EvrythngApiBuilder.Builder<List<T>> actionsReader(String productId, Class<T> actionClass) throws EvrythngClientException {
        String type = this.getType(actionClass);
        return this.get(String.format(PATH_PRODUCT_TYPED_ACTIONS, productId, type), new TypeReference<List<Action>>(){});
    }

    public EvrythngApiBuilder.Builder<List<CustomAction>> actionsReader(String productId, String customType) throws EvrythngClientException {
        this.checkCustomType(customType);
        return this.get(String.format(PATH_PRODUCT_TYPED_ACTIONS, productId, customType), new TypeReference<List<CustomAction>>(){});
    }

    protected void checkCustomType(String customType) {
        if (!customType.startsWith("_")) {
            throw new IllegalArgumentException("Custom types must start with '_' (underscore).");
        }
    }

    public <T extends Action> String getType(Class<T> actionClass) {
        String type = this.deserializer.getActionType(actionClass);
        if (type == null) {
            throw new IllegalArgumentException("The action type is not recognized.");
        }
        return type;
    }
}

