/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.thng.resource.model.store.ReactorSchedule;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;

public class ReactorSchedulesService
extends EvrythngServiceBase {
    private static final String PATH_REACTOR_SCHEDULES = "/projects/%s/applications/%s/reactor/schedules";
    private static final String PATH_REACTOR_SCHEDULE = "/projects/%s/applications/%s/reactor/schedules/%s";

    public ReactorSchedulesService(ApiManager api) {
        super(api);
    }

    private static String reactorSchedulesUrl(String projectId, String appId) {
        return String.format(PATH_REACTOR_SCHEDULES, projectId, appId);
    }

    private static String reactorScheduleUrl(String projectId, String appId, String reactorScheduleId) {
        return String.format(PATH_REACTOR_SCHEDULE, projectId, appId, reactorScheduleId);
    }

    public EvrythngApiBuilder.Builder<List<ReactorSchedule>> reactorSchedulesReader(String projectId, String appId) throws EvrythngClientException {
        return this.get(ReactorSchedulesService.reactorSchedulesUrl(projectId, appId), new TypeReference<List<ReactorSchedule>>(){});
    }

    public EvrythngApiBuilder.Builder<ReactorSchedule> reactorScheduleReader(String projectId, String appId, String reactorScheduleId) throws EvrythngClientException {
        return this.get(ReactorSchedulesService.reactorScheduleUrl(projectId, appId, reactorScheduleId), new TypeReference<ReactorSchedule>(){});
    }

    public EvrythngApiBuilder.Builder<ReactorSchedule> reactorScheduleUpdater(String projectId, String appId, String reactorScheduleId, ReactorSchedule reactorSchedule) throws EvrythngClientException {
        return this.put(ReactorSchedulesService.reactorScheduleUrl(projectId, appId, reactorScheduleId), reactorSchedule, new TypeReference<ReactorSchedule>(){});
    }

    public EvrythngApiBuilder.Builder<ReactorSchedule> reactorScheduleCreator(String projectId, String appId, ReactorSchedule reactorSchedule) throws EvrythngClientException {
        return this.post(ReactorSchedulesService.reactorSchedulesUrl(projectId, appId), reactorSchedule, new TypeReference<ReactorSchedule>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> reactorScheduleDeleter(String projectId, String appId, String reactorScheduleId) throws EvrythngClientException {
        return this.delete(ReactorSchedulesService.reactorScheduleUrl(projectId, appId, reactorScheduleId));
    }
}

