/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.core.api.QueryParamValue;
import com.evrythng.java.wrapper.core.http.Status;
import com.evrythng.java.wrapper.exception.EvrythngException;
import com.evrythng.thng.resource.model.li.UrlBinding;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;

public class ScanService
extends EvrythngServiceBase {
    public static final String PATH_SCAN = "/scan";
    public static final String PATH_SCAN_RECOGNITIONS = "/scan/recognitions";
    public static final String PATH_SCAN_BARCODE = "/scan/barcode";

    public ScanService(ApiManager api) {
        super(api);
    }

    public EvrythngApiBuilder.Builder<UrlBinding> recognitionCreator(String base64Image) throws EvrythngException {
        return this.recognitionCreator(base64Image, RecognitionType.AUTODETECT);
    }

    public EvrythngApiBuilder.Builder<UrlBinding> recognitionCreator(String base64Image, RecognitionType type) throws EvrythngException {
        UrlBinding imageInBinding = new UrlBinding();
        imageInBinding.setImage(base64Image);
        return this.recognitionCreator(imageInBinding, type);
    }

    public EvrythngApiBuilder.Builder<UrlBinding> recognitionCreator(InputStream image, String mime, RecognitionType type) throws EvrythngException, IOException {
        String mimeAndB64 = this.encodeBase64(image, mime);
        return this.recognitionCreator(mimeAndB64, type);
    }

    public EvrythngApiBuilder.Builder<UrlBinding> recognitionCreator(UrlBinding imageInBinding) throws EvrythngException {
        return this.recognitionCreator(imageInBinding, RecognitionType.AUTODETECT);
    }

    public EvrythngApiBuilder.Builder<UrlBinding> recognitionCreator(UrlBinding imageInBinding, RecognitionType type) throws EvrythngException {
        EvrythngApiBuilder.Builder<UrlBinding> result = this.post(PATH_SCAN_RECOGNITIONS, imageInBinding, Status.OK, new TypeReference<UrlBinding>(){});
        result.queryParam(type.getQueryParam());
        return result;
    }

    public EvrythngApiBuilder.Builder<UrlBinding> scanBarcodeCreator(UrlBinding scanBarcodeData) throws EvrythngException {
        return this.post(PATH_SCAN_BARCODE, scanBarcodeData, Status.OK, new TypeReference<UrlBinding>(){});
    }

    public static enum RecognitionType {
        ONEDBARCODE("1dbarcode"),
        QRCODE("qrcode"),
        OBJPIC("objpic"),
        DATAMATRIX("datamatrix"),
        AUTODETECT("autodetect");

        private final String queryParam;
        public static final String TYPE_QUERY_PARAM_KEY = "type";

        private RecognitionType(String queryParam) {
            this.queryParam = queryParam;
        }

        public QueryParamValue getQueryParam() {
            return new QueryParamValue(TYPE_QUERY_PARAM_KEY, this.queryParam);
        }
    }
}

