/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.core.api.param.EvrythngIdQueryParamValue;
import com.evrythng.java.wrapper.core.http.Status;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.java.wrapper.service.QrCodeType;
import com.evrythng.thng.resource.model.li.UrlBinding;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.util.List;

public class UrlBindingService
extends EvrythngServiceBase {
    public static final String PATH_URLS = "/redirections";
    public static final String PATH_URL_BINDING = "/redirections/%s";
    public static final String PATH_URL_BINDING_QR = "/redirections/%s.qr";

    public UrlBindingService(ApiManager api) {
        super(api);
    }

    public EvrythngApiBuilder.Builder<UrlBinding> bindingCreator(UrlBinding binding) throws EvrythngClientException {
        return this.post(PATH_URLS, binding, new TypeReference<UrlBinding>(){});
    }

    public EvrythngApiBuilder.Builder<List<UrlBinding>> bindingsReader() throws EvrythngClientException {
        return this.get(PATH_URLS, new TypeReference<List<UrlBinding>>(){});
    }

    public EvrythngApiBuilder.Builder<InputStream> bindingCreatorReturnQr(UrlBinding binding) throws EvrythngClientException {
        return this.post(PATH_URLS, binding, Status.OK, new TypeReference<InputStream>(){}).accept("image/png");
    }

    public EvrythngApiBuilder.Builder<List<UrlBinding>> bindingsReader(String evrythngId) throws EvrythngClientException {
        return super.get(PATH_URLS, new TypeReference<List<UrlBinding>>(){}).queryParam(EvrythngIdQueryParamValue.id(evrythngId));
    }

    public EvrythngApiBuilder.Builder<UrlBinding> bindingReader(String shortId) throws EvrythngClientException {
        return this.get(String.format(PATH_URL_BINDING, shortId), new TypeReference<UrlBinding>(){});
    }

    public EvrythngApiBuilder.Builder<UrlBinding> bindingUpdater(String shortId, UrlBinding binding) throws EvrythngClientException {
        return this.put(String.format(PATH_URL_BINDING, shortId), binding, new TypeReference<UrlBinding>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> bindingDeleter(String shortId) throws EvrythngClientException {
        return this.delete(String.format(PATH_URL_BINDING, shortId));
    }

    public EvrythngApiBuilder.Builder<InputStream> bindingQrCodeReader(String shortId, QrCodeType type) throws EvrythngClientException {
        String accept;
        switch (type) {
            case PDF: {
                accept = "application/pdf";
                break;
            }
            case SVG: {
                accept = "image/svg+xml";
                break;
            }
            default: {
                accept = "image/png";
            }
        }
        return this.get(String.format(PATH_URL_BINDING_QR, shortId), new TypeReference<InputStream>(){}).accept(accept);
    }

    public EvrythngApiBuilder.Builder<Long> bindingsUpdater(UrlBinding update) throws EvrythngClientException {
        return this.put(PATH_URLS, update, new TypeReference<Long>(){});
    }

    public EvrythngApiBuilder.Builder<Long> bindingsDeleter() throws EvrythngClientException {
        return this.deleteMultiple(PATH_URLS);
    }
}

