/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);
    public static final String X_AMZ_ACL_HEADER_NAME = "x-amz-acl";
    public static final String X_AMZ_ACL_HEADER_VALUE_PUBLIC_READ = "public-read";
    public static final String X_AMZ_ACL_HEADER_VALUE_PRIVATE = "private";

    public static void uploadFile(URL url, String contentType, File file) throws IOException {
        FileUtils.uploadPublicFile(url, contentType, file);
    }

    public static void uploadPublicFile(URL url, String contentType, File file) throws IOException {
        HttpURLConnection connection = FileUtils.getConnectionForPublicUpload(url, contentType);
        try (OutputStream output = connection.getOutputStream();
             WritableByteChannel wbc = Channels.newChannel(output);
             FileInputStream fis = new FileInputStream(file);
             FileChannel fc = fis.getChannel();){
            fc.transferTo(0L, fc.size(), wbc);
        }
        FileUtils.validateConnectionAfterUpload(connection);
    }

    public static void uploadPublicFile(URL url, File file) throws IOException {
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        FileUtils.uploadPublicFile(url, contentType, file);
    }

    public static void uploadContent(URL url, String contentType, String content) throws IOException {
        FileUtils.uploadPublicContent(url, contentType, content);
    }

    public static void uploadPublicContent(URL url, String contentType, String content) throws IOException {
        HttpURLConnection connection = FileUtils.getConnectionForPublicUpload(url, contentType);
        try (OutputStream output = connection.getOutputStream();
             BufferedOutputStream bos = new BufferedOutputStream(output);){
            bos.write(content.getBytes());
        }
        FileUtils.validateConnectionAfterUpload(connection);
    }

    public static void uploadPrivateContent(URI uri, String contentTypeString, String contentString) throws IOException {
        LOGGER.info("uploadPrivateContent START: uri: [{}]; content type: [{}], content length: [{}]", new Object[]{uri, contentTypeString, contentString.length()});
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpPut httpPut = new HttpPut(uri);
        httpPut.addHeader("Content-Type", contentTypeString);
        httpPut.addHeader(X_AMZ_ACL_HEADER_NAME, X_AMZ_ACL_HEADER_VALUE_PRIVATE);
        ContentType contentType = ContentType.create((String)contentTypeString);
        StringEntity stringEntity = new StringEntity(contentString, contentType);
        httpPut.setEntity((HttpEntity)stringEntity);
        CloseableHttpResponse response = closeableHttpClient.execute((HttpUriRequest)httpPut);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            throw new IOException(String.format("An error occurred while trying to upload private file - %d: %s", statusLine.getStatusCode(), statusLine.getReasonPhrase()));
        }
        LOGGER.info("uploadPrivateContent END: uri: [{}]; content type: [{}], content length: [{}]", new Object[]{uri, contentTypeString, contentString.length()});
    }

    public static void uploadPrivateContent(URI uri, String contentTypeString, File contentFile) throws IOException {
        LOGGER.info("uploadPrivateContent START: uri: [{}]; content type: [{}], content file: [{}]", new Object[]{uri, contentTypeString, contentFile});
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpPut httpPut = new HttpPut(uri);
        httpPut.addHeader("Content-Type", contentTypeString);
        httpPut.addHeader(X_AMZ_ACL_HEADER_NAME, X_AMZ_ACL_HEADER_VALUE_PRIVATE);
        ContentType contentType = ContentType.create((String)contentTypeString);
        FileEntity fileEntity = new FileEntity(contentFile, contentType);
        httpPut.setEntity((HttpEntity)fileEntity);
        CloseableHttpResponse response = closeableHttpClient.execute((HttpUriRequest)httpPut);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            throw new IOException(String.format("An error occurred while trying to upload private file - %d: %s", statusLine.getStatusCode(), statusLine.getReasonPhrase()));
        }
        LOGGER.info("uploadPrivateContent END: uri: [{}]; content type: [{}], content file: [{}]", new Object[]{uri, contentTypeString, contentFile});
    }

    public static void uploadStream(URL url, String contentType, InputStream stream) throws IOException {
        FileUtils.uploadPublicStream(url, contentType, stream);
    }

    public static void uploadPublicStream(URL url, String contentType, InputStream stream) throws IOException {
        HttpURLConnection connection = FileUtils.getConnectionForPublicUpload(url, contentType);
        try (OutputStream output = connection.getOutputStream();){
            IOUtils.copy((InputStream)stream, (OutputStream)output);
        }
        FileUtils.validateConnectionAfterUpload(connection);
    }

    private static HttpURLConnection getConnectionForPublicUpload(URL url, String contentType) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", contentType);
        connection.setRequestProperty(X_AMZ_ACL_HEADER_NAME, X_AMZ_ACL_HEADER_VALUE_PUBLIC_READ);
        connection.setDoOutput(true);
        connection.connect();
        return connection;
    }

    private static HttpURLConnection getConnectionForPrivateUpload(URL url, String contentType) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", contentType);
        connection.setRequestProperty(X_AMZ_ACL_HEADER_NAME, X_AMZ_ACL_HEADER_VALUE_PRIVATE);
        connection.setDoOutput(true);
        connection.connect();
        return connection;
    }

    private static void validateConnectionAfterUpload(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            try (InputStream is = connection.getInputStream();){
                while (is.read() > 0) {
                }
            }
        } else {
            InputStream is = connection.getErrorStream();
            Throwable throwable = null;
            try {
                try {
                    String error = IOUtils.toString((InputStream)is);
                    throw new IOException(String.format("Unable to upload file. Got error %d %s: %s", responseCode, connection.getResponseMessage(), error));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        is.close();
                    }
                }
                throw throwable3;
            }
        }
        connection.disconnect();
    }
}

