package com.fasc.open.api.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.req.corp.*;
import com.fasc.open.api.bean.res.common.UrlRes;
import com.fasc.open.api.bean.res.corp.*;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;

/**
 * @author Fadada
 * 2021/10/16 16:48:09
 */
public class CorpClient {
    private OpenApiClient openApiClient;

    public CorpClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }


    public BaseRes<AddOpenCorpRes> add(AddCorpReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.CORP_ADD, AddOpenCorpRes.class);
    }

    public BaseRes<Void> update(UpdateCorpReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.CORP_UPDATE, Void.class);
    }

    public BaseRes<Void> delete(DeleteCorpReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.CORP_DELETE, Void.class);
    }

    public BaseRes<CorpDetailRes> getDetail(GetCorpDetailReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.CORP_GET_DETAIL, CorpDetailRes.class);
    }

    public BaseRes<UrlRes> generateIdentifyUrl(GenerateCorpIdentifyUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.CORP_GENERATE_IDENTIFY_URL, UrlRes.class);
    }

    public BaseRes<CorpIdentityProgressRes> getIdentityProgress(GetCorpIdentityProgressReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.CORP_GET_IDENTITY_PROGRESS, CorpIdentityProgressRes.class);
    }

    public BaseRes<UrlRes> generateAuthUrl(GenerateCorpAuthUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.CORP_GENERATE_AUTH_URL, UrlRes.class);
    }

    public BaseRes<CorpAuthTokenRes> getAuthToken(GetCorpAuthTokenReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.CORP_GET_AUTH_TOKEN, CorpAuthTokenRes.class);
    }

    public BaseRes<CorpIdentityInfoRes> getIdentityInfo(GetCorpIdentityInfoReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.CORP_GET_IDENTITY_INFO, CorpIdentityInfoRes.class);
    }
}
