package com.fasc.open.api.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.req.doc.DocUploadReq;
import com.fasc.open.api.bean.req.doc.FileUploadReq;
import com.fasc.open.api.bean.res.doc.DocUploadRes;
import com.fasc.open.api.bean.res.doc.FileUploadRes;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Fadada
 * 2021/9/8 16:09:38
 */
public class DocClient {
    private OpenApiClient openApiClient;

    public DocClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<DocUploadRes> docUpload(File docContent, DocUploadReq req) throws ApiException {
        Map<String, File> fileMap = new HashMap<>(1);
        if (docContent != null) {
            fileMap.put(OpenApiUrlConstants.DOC_UPLOAD_FILE_KEY, docContent);
        }
        return openApiClient.invokeApi(req, OpenApiUrlConstants.DOC_UPLOAD, fileMap, DocUploadRes.class);
    }

    public BaseRes<FileUploadRes> fileUpload(File fileContent, FileUploadReq req) throws ApiException {
        Map<String, File> fileMap = new HashMap<>(1);
        if (fileContent != null) {
            fileMap.put(OpenApiUrlConstants.FILE_UPLOAD_FILE_KEY, fileContent);
        }
        return openApiClient.invokeApi(req, OpenApiUrlConstants.FILE_UPLOAD, fileMap, FileUploadRes.class);
    }


}
