package com.fasc.open.api.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.req.doctemplate.DocTemplateDetailReq;
import com.fasc.open.api.bean.req.doctemplate.DocTemplateListOnAppReq;
import com.fasc.open.api.bean.req.doctemplate.DocTemplateListOnClientReq;
import com.fasc.open.api.bean.res.doctemplate.DocTemplateDetailRes;
import com.fasc.open.api.bean.res.doctemplate.DocTemplateListRes;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;

/**
 * @author Fadada
 * 2021/9/8 16:09:38
 */
public class DocTemplateClient {
    private OpenApiClient openApiClient;

    public DocTemplateClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<DocTemplateListRes> getListOnClient(DocTemplateListOnClientReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.DOC_TEMPLATE_GET_LIST_ON_CLIENT, DocTemplateListRes.class);
    }

    public BaseRes<DocTemplateListRes> getListOnApp(DocTemplateListOnAppReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.DOC_TEMPLATE_GET_LIST_ON_APP, DocTemplateListRes.class);
    }

    public BaseRes<DocTemplateDetailRes> getDetail(DocTemplateDetailReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.DOC_TEMPLATE_GET_DETAIL, DocTemplateDetailRes.class);
    }

}
