package com.fasc.open.api.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.base.BaseResponseEntity;
import com.fasc.open.api.bean.req.signtask.*;
import com.fasc.open.api.bean.res.common.UrlRes;
import com.fasc.open.api.bean.res.signtask.AddAttachsRes;
import com.fasc.open.api.bean.res.signtask.AddDocsRes;
import com.fasc.open.api.bean.res.signtask.CreateSignTaskRes;
import com.fasc.open.api.bean.res.signtask.SignTaskDetailRes;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;

/**
 * @author Fadada
 * 2021/9/13 17:10:09
 */
public class SignTaskClient {
    private OpenApiClient openApiClient;

    public SignTaskClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }


    public BaseRes<CreateSignTaskRes> create(CreateSignTaskReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_CREATE, CreateSignTaskRes.class);
    }

    public BaseRes<CreateSignTaskRes> createWithDocs(CreateWithDocsReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_CREATE_WITH_DOCS, CreateSignTaskRes.class);
    }

    public BaseRes<CreateSignTaskRes> createWithTemplate(CreateWithTemplateReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_CREATE_WITH_TEMPLATE, CreateSignTaskRes.class);
    }

    public BaseRes<AddDocsRes> addDocs(AddDocsReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_ADD_DOCS, AddDocsRes.class);
    }

    public BaseRes<Void> deleteDocs(DeleteDocsReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_DELETE_DOCS, Void.class);
    }

    public BaseRes<AddAttachsRes> addAttachs(AddAttachsReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_ADD_ATTACHS, AddAttachsRes.class);
    }

    public BaseRes<Void> deleteAttachs(DeleteAttachsReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_DELETE_ATTACHS, Void.class);
    }

    public BaseRes<Void> addActors(AddActorsReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_ADD_ACTORS, Void.class);
    }

    public BaseRes<Void> deleteActor(DeleteActorReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_DELETE_ACTOR, Void.class);
    }


    public BaseRes<Void> initiate(SignTaskBaseReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_INITIATE, Void.class);
    }

    public BaseRes<Void> finalizeDocs(SignTaskBaseReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_FINALIZE_DOCS, Void.class);
    }

    public BaseRes<Void> cancel(SignTaskBaseReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_CANCEL, Void.class);
    }

    public BaseRes<Void> unblock(UnblockReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_UNBLOCK, Void.class);
    }

    public BaseRes<Void> finish(SignTaskBaseReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_FINISH, Void.class);
    }

    public BaseRes<SignTaskDetailRes> getDetail(SignTaskBaseReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_GET_DETAIL, SignTaskDetailRes.class);
    }

    public BaseRes<BaseResponseEntity> downloadDocs(DownloadDocsReq req) throws ApiException {
        return openApiClient.invokeApiDownload(req, OpenApiUrlConstants.SIGN_TASK_DOWNLOAD_DOCS);
    }

    public BaseRes<UrlRes> generateFieldsEditUrl(GenerateFieldsEditUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_GENERATE_FIELDS_EDIT_URL, UrlRes.class);
    }

    public BaseRes<UrlRes> generateActorUserUrl(GenerateActorUserUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TASK_GENERATE_ACTOR_USER_URL, UrlRes.class);
    }


}
