package com.fasc.open.api.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.req.signtemplate.SignTemplateDetailReq;
import com.fasc.open.api.bean.req.signtemplate.SignTemplateListOnAppReq;
import com.fasc.open.api.bean.req.signtemplate.SignTemplateListOnClientReq;
import com.fasc.open.api.bean.res.signtemplate.SignTemplateDetailRes;
import com.fasc.open.api.bean.res.signtemplate.SignTemplateListRes;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;

/**
 * @author Fadada
 * 2021/9/8 16:09:38
 */
public class SignTemplateClient {
    private OpenApiClient openApiClient;

    public SignTemplateClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<SignTemplateListRes> getListOnClient(SignTemplateListOnClientReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TEMPLATE_GET_LIST_ON_CLIENT, SignTemplateListRes.class);
    }

    public BaseRes<SignTemplateListRes> getListOnApp(SignTemplateListOnAppReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TEMPLATE_GET_LIST_ON_APP, SignTemplateListRes.class);
    }

    public BaseRes<SignTemplateDetailRes> getDetail(SignTemplateDetailReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.SIGN_TEMPLATE_GET_DETAIL, SignTemplateDetailRes.class);
    }

}
