package com.fasc.open.api.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.req.user.*;
import com.fasc.open.api.bean.res.common.UrlRes;
import com.fasc.open.api.bean.res.user.*;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;

/**
 * @author Fadada
 * 2021/10/16 16:47:06
 */
public class UserClient {
    private OpenApiClient openApiClient;

    public UserClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<AddOpenUserRes> add(AddUserReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_ADD, AddOpenUserRes.class);
    }

    public BaseRes<Void> update(UpdateUserReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_UPDATE, Void.class);
    }

    public BaseRes<Void> delete(DeleteUserReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_DELETE, Void.class);
    }

    public BaseRes<UserDetailRes> getDetail(GetUserDetailReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_GET_DETAIL, UserDetailRes.class);
    }

    public BaseRes<UrlRes> generateIdentifyUrl(GenerateUserIdentifyUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_GENERATE_IDENTIFY_URL, UrlRes.class);
    }

    public BaseRes<UserIdentityProgressRes> getIdentityProgress(GetUserIdentityProgressReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_GET_IDENTITY_PROGRESS, UserIdentityProgressRes.class);
    }

    public BaseRes<UrlRes> generateAuthUrl(GenerateUserAuthUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_GENERATE_AUTH_URL, UrlRes.class);
    }

    public BaseRes<UserAuthTokenRes> getAuthToken(GetUserAuthTokenReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_GET_AUTH_TOKEN, UserAuthTokenRes.class);
    }

    public BaseRes<UserIdentityInfoRes> getIdentityInfo(GetUserIdentityInfoReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_GET_IDENTITY_INFO, UserIdentityInfoRes.class);
    }
}
