package com.fasc.open.api.enums.common;

/**
 * @author Fadada
 * 2021/9/23 11:03:46
 */
public enum FieldTypeEnum {

    /**
     * 控件类型：
     * PERSON_SIGNATURE: 个人签名
     * CORPORATE_SEAL: 企业印章
     * DATE_SIGNATURE: 日期戳 (备注：未来将迭代修改实现方式)
     * TEXT_SINGLE_LINE: 单行文本
     * TEXT_MULTI_LINE: 多行文本
     * CHECK_BOX: 复选框
     * ATTACHMENT: 附件 (备注：未来将迭代修改实现方式)
     * TABLE: 表格
     * IMAGE: 图片
     */


    PERSON_SIGNATURE("PERSON_SIGNATURE", "个人签名"),
    CORPORATE_SEAL("CORPORATE_SEAL", "企业印章"),
    DATE_SIGNATURE("DATE_SIGNATURE", "日期戳"),
    TEXT_SINGLE_LINE("TEXT_SINGLE_LINE", "单行文本"),
    TEXT_MULTI_LINE("TEXT_MULTI_LINE", "多行文本"),
    CHECK_BOX("CHECK_BOX", "复选框"),
    ATTACHMENT("ATTACHMENT", "附件"),
    TABLE("TABLE", "表格"),
    IMAGE("IMAGE", "图片");


    private String code;
    private String remark;

    FieldTypeEnum(String code, String remark) {
        this.code = code;
        this.remark = remark;
    }

    public String getCode() {
        return code;
    }

    public String getRemark() {
        return remark;
    }
}
