package com.fasc.open.api.enums.corp;

/**
 * @author Fadada
 * 2021/10/23 16:19:25
 */
public enum CorpIdentMethodEnum {
    /**
     * 企业实名认证时所选择的认证方案：
     * 1: 法定代表人身份认证 (企业经办人为法定代表人时，可选法定代表人身份认证)
     * 2: 法定代表人授权认证 (企业经办人为代理人时，可选法定代表人授权认证)
     * 3: 企业对公账户认证 (使用企业在银行开立的对公账户验证并通过打款验证其关系)
     * 4: 纸质材料审核认证 (企业线上提供资料提交进行预审，并在线下提供材料进行审核，周期较长)。
     */

    IDENTIFICATION_OF_LEGAL_REPRESENTATIVE(1, "法定代表人身份认证"),
    AUTHORIZED_AUTHENTICATION_OF_LEGAL_REPRESENTATIVE(2, "法定代表人授权认证"),
    ENTERPRISE_TO_CORPORATE_ACCOUNT_AUTHENTICATION(3, "企业对公账户认证"),
    PAPER_MATERIAL_AUDIT_AND_CERTIFICATION(4, "纸质材料审核认证");

    private Integer code;
    private String remark;

    CorpIdentMethodEnum(Integer code, String remark) {
        this.code = code;
        this.remark = remark;
    }

    public Integer getCode() {
        return code;
    }

    public String getRemark() {
        return remark;
    }

}
