package com.fasc.open.api.enums.corp;

/**
 * @author Fadada
 * 2021/9/23 10:12:54
 */
public enum CorpIdentTypeEnum {
    /**
     * 企业组织类型：
     * 1: 企业
     * 2: 个体工商户
     * 3: 政府和事业单位
     * 4: 其他组织机构。
     */
    ENTERPRISE(1, "企业"),

    INDIVIDUAL_BUSINESS(2, "个体工商户"),

    GOVERNMENT_AND_PUBLIC_INSTITUTIONS(3, "政府和事业单位"),

    OTHER_ORGANIZATIONS(4, "其他组织机构");

    private Integer code;
    private String remark;

    CorpIdentTypeEnum(Integer code, String remark) {
        this.code = code;
        this.remark = remark;
    }

    public Integer getCode() {
        return code;
    }

    public String getRemark() {
        return remark;
    }
}
