package com.fasc.open.api.enums.corp;

/**
 * @author Fadada
 * 2021/10/23 16:20:39
 */
public enum OperatorIdentMethodEnum {
    /**
     * 经办人实名认证时所采用的认证方式：
     * 1: 实名手机号认证：该方案校验的是认证人在电信运营商绑定的姓名、身份证号码、运营商手机号
     * 2: 人脸识别认证：该方案校验的是认证人的姓名、身份证号码、人脸比对
     * 3: 个人银行卡认证：该方案校验的是认证人在银行绑定的姓名、身份证号码、银行预留手机号、银行卡卡号
     * 4: 人工审核认证：该方案主要为特殊人群提供的人工认证通道(如部分用户因为特殊原因，无法在其他方案下认证通过)。
     */
    REAL_NAME_MOBILE_AUTHENTICATION(1, "实名手机号认证"),
    FACE_RECOGNITION_AUTHENTICATION(2, "人脸识别认证"),
    PERSONAL_BANK_CARD_AUTHENTICATION(3, "个人银行卡认证"),
    MANUAL_AUDIT_AND_AUTHENTICATION(4, "人工审核认证");

    private Integer code;
    private String remark;

    OperatorIdentMethodEnum(Integer code, String remark) {
        this.code = code;
        this.remark = remark;
    }

    public Integer getCode() {
        return code;
    }

    public String getRemark() {
        return remark;
    }

}
