package com.fasc.open.api.enums.corp;

/**
 * @author Fadada
 * 2021/10/23 16:20:06
 */
public enum OperatorIdentProcessStatusEnum {
    /**
     * <p>
     * 经办人实名认证状态：
     * 1: 未认证
     * 2: 认证中
     * 3: 审核中
     * 4: 认证通过
     * 5: 认证不通过。
     */
    UNVERIFIED(1, "未认证"),
    VERIFYING(2, "认证中"),
    AUDIT(3, "审核中"),
    VERIFIED(4, "认证通过"),
    VERIFIED_FAILED(5, "认证不通过");

    private Integer code;
    private String remark;

    OperatorIdentProcessStatusEnum(Integer code, String remark) {
        this.code = code;
        this.remark = remark;
    }

    public Integer getCode() {
        return code;
    }

    public String getRemark() {
        return remark;
    }

}
