package com.fasc.open.api.enums.event;

import java.util.Objects;

/**
 * @author Fadada
 * 2021/10/21 15:37:11
 */
public enum CallbackEventEnum {
    /**
     * 回调事件枚举
     */
    USER_IDENTITY_VERIFIED("user-identity-verified", "用户实名绑定事件"),
    USER_AUTHORIZED("user-authorized", "用户授权完成事件"),
    CORP_IDENTITY_VERIFIED("corp-identity-verified", "企业实名绑定事件"),
    CORP_AUTHORIZED("corp-authorized", "企业授权完成事件"),
    SIGN_TASK_FILLED("sign-task-filled", "签署任务填写事件"),
    SIGN_TASK_FILL_REFUSED("sign-task-fill-refused", "签署任务拒填事件"),
    SIGN_TASK_SIGNED("sign-task-signed", "签署任务签署事件"),
    SIGN_TASK_SIGN_REFUSED("sign-task-sign-refused", "签署任务拒签事件"),
    SIGN_TASK_FINISHED("sign-task-finished", "签署任务完成事件"),
    SIGN_TASK_CANCELED("sign-task-canceled", "签署任务撤销事件");

    private String eventCode;
    private String eventName;

    CallbackEventEnum(String eventCode, String eventName) {
        this.eventCode = eventCode;
        this.eventName = eventName;
    }

    public String getEventCode() {
        return eventCode;
    }

    public String getEventName() {
        return eventName;
    }

    /**
     * 根据事件编码返回指定枚举
     *
     * @param eventCode 事件编码
     * @return 事件枚举
     */
    public static CallbackEventEnum getCallbackEventEnum(String eventCode) {
        for (CallbackEventEnum callbackEventEnum : CallbackEventEnum.values()) {
            if (Objects.equals(callbackEventEnum.eventCode, eventCode)) {
                return callbackEventEnum;
            }
        }
        return null;
    }

}
