package com.fasc.open.api.enums.signtask;

/**
 * @author Fadada
 * 2021/9/23 11:12:04
 */
public enum FillActorStatusEnum {

    /**
     * 填写方状态：
     * 1: 未投递(NoSend): 尚未发送给本填写方
     * 2: 待接收(ToAccept)：正在等待本填写方接收
     * 3: 已接收(Accepted) ：已被本填写方接收
     * 4: 待填写(ToFill)：等待本填写方填写
     * 5: 已填写(Filled)：本填写方已完成了需自己必填控件的填写
     * 6: 已拒填(Refused)：本填写方拒绝了填写
     */
    NO_SEND(1, "未投递"),
    TO_ACCEPT(2, "待接收"),
    ACCEPTED(3, "已接收"),
    TO_FILL(4, "待填写"),
    FILLED(5, "已填写"),
    REFUSED(6, "已拒填");
    private Integer code;
    private String remark;

    FillActorStatusEnum(Integer code, String remark) {
        this.code = code;
        this.remark = remark;
    }

    public Integer getCode() {
        return code;
    }

    public String getRemark() {
        return remark;
    }
}
