package com.fasc.open.api.enums.signtask;

/**
 * @author Fadada
 * 2021/9/23 11:12:22
 */
public enum SignActorStatusEnum {
    /**
     * 签署方状态：
     * 1: 未投递(NoSend)：尚未发送给本签署方
     * 2: 待接收(ToAccept)：正在等待本签署方接收
     * 3: 已接收(Accepted)：已被本签署方已接收
     * 4: 待签署(ToSign)：等待本签署方签署
     * 5: 已签署(Signed)：本签署方已完成签署
     * 6: 已拒签(Refused)：本签署方拒绝了签署
     * 7: 阻塞中(Blocked)：本签署方被阻塞
     * 8: 已转签(Transferred)：本签署方经办人已转给其他经办人，但还在本签署方
     */
    NO_SEND(1, "未投递"),
    TO_ACCEPT(2, "待接收"),
    ACCEPTED(3, "已接收"),
    TO_BE_SIGNED(4, "待签署"),
    SIGNED(5, "已签署"),
    IN_THE_LOCK(6, "已拒签"),
    REFUSE_SIGNED(7, "阻塞中"),
    TRANSFORM_SIGNED(8, "已转签");

    private Integer code;
    private String remark;

    SignActorStatusEnum(Integer code, String remark) {
        this.code = code;
        this.remark = remark;
    }

    public Integer getCode() {
        return code;
    }

    public String getRemark() {
        return remark;
    }
}
