package com.fasc.open.api.enums.signtask;

/**
 * @author Fadada
 * 2021/9/23 11:11:38
 */
public enum SignTaskStatusEnum {
    /**
     * 签署任务状态
     * 1: 任务已创建(TaskCreated)：签署任务创建成功，但未发起
     * 2: 任务已发起(TaskInitiated)：签署任务已经发起
     * 3: 填写进行中(FillInProgress)：签署任务正在进行协同填写流程阶段，必填控件尚未填完
     * 4: 填写已完成(FillCompleted)：签署任务文档中所有的必填控件均已填写，但文档尚未定稿
     * 5: 定稿中(FillFinalizing)：签署任务正在进行文档定稿
     * 6: 已定稿(FillFinalized)：签署任务已完成文档定稿
     * 7: 签署进行中(SignInProgress)：签署任务正在进行签署流程阶段
     * 8: 签署已完成(SignCompleted)：签署任务所有签署方均已签署完成
     * 9: 任务已结束(TaskFinished)：签署任务已结束
     * 10: 任务已撤销(TaskCanceled)：签署任务已经被撤销
     * 11: 任务已终止(TaskStopped)：签署任务已经因为某种原因而终止(流入因为某方拒填或拒签)。
     */
    TASK_CREATED(1, "已创建"),
    TASK_INITIATED(2, "已发起"),
    FILL_IN_PROGRESS(3, "填写中"),
    FILL_COMPLETED(4, "已填写"),
    FILL_FINALIZING(5, "定稿中"),
    FILL_FINALIZED(6, "已定稿"),
    SIGN_IN_PROGRESS(7, "签署中"),
    SIGN_COMPLETED(8, "已签署"),
    TASK_FINISHED(9, "已完成"),
    TASK_CANCELED(10, "已撤销"),
    TASK_STOPPED(11, "已终止");

    private Integer code;
    private String remark;

    SignTaskStatusEnum(Integer code, String remark) {
        this.code = code;
        this.remark = remark;
    }

    public Integer getCode() {
        return code;
    }

    public String getRemark() {
        return remark;
    }
}
