package com.fasc.open.api.enums.signtask;

/**
 * @author Fadada
 * 2021/9/23 11:09:04
 */
public enum VerifyMethodEnum {
    /**
     * 签署意愿1 短信，2 刷脸，3 邮件
     */
    /**
     * 允许该参与方使用的身份和意愿确认方式：
     * 1: 短信验证码
     * 2: 刷脸验证
     * 3: 邮件验证码默认选择全部。
     */
    SMS_VERIFICATION_CODE(1, "短信验证码"),

    BRUSH_FACE_VERIFICATION(2, "刷脸验证"),

    EMAIL_VERIFICATION_CODE(3, "邮件验证码");

    private Integer code;
    private String remark;

    VerifyMethodEnum(Integer code, String remark) {
        this.code = code;
        this.remark = remark;
    }

    public Integer getCode() {
        return code;
    }

    public String getRemark() {
        return remark;
    }
}
