package com.fasc.open.api.enums.user;

/**
 * @author Fadada
 * 2021/10/23 16:28:03
 */
public enum IdentStatusEnum {
    /**
     * 实名认证状态：
     * 1: 未认证
     * 2: 已认证
     * 3: 认证失效 (如过期或其他情况导致的失效，等同于“未认证”，需重新认证才可使用服务)该参数非常重要，因为只有有效实名认证的用户方可使用法大大电子签服务。
     */

    UNVERIFIED(1, "未认证"),
    VERIFIED(2, "已认证"),
    VERIFIED_FAILURE(3, "认证失效");
    private Integer code;
    private String remark;

    IdentStatusEnum(Integer code, String remark) {
        this.code = code;
        this.remark = remark;
    }

    public Integer getCode() {
        return code;
    }

    public String getRemark() {
        return remark;
    }
}
