package com.fasc.open.api.utils;


import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.stratey.JsonStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Fadada
 * 2021/9/8 16:09:38
 */
public class ResultUtil {

    private static final Logger log = LoggerFactory.getLogger(ResultUtil.class);

    private ResultUtil() {
    }

    /**
     * 请求结果校验抛出异常 并打日志
     *
     * @param baseRes      响应base
     * @param jsonStrategy 策率
     * @throws ApiException 异常
     */
    public static void checkResult(BaseRes baseRes, JsonStrategy jsonStrategy) throws ApiException {
        if (baseRes == null) {
            log.error("请求失败：{}", baseRes);
            throw new ApiException("请求失败");
        }
        String json = jsonStrategy.toJson(baseRes);

        if (!Boolean.TRUE.equals(baseRes.isSuccess())) {
            log.error("请求失败：{}", json);
            throw new ApiException(baseRes.getMsg());
        }
        log.info("请求结果为：{}", json);
    }


}
