import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.common.CorpIdentInfo;
import com.fasc.open.api.bean.common.Notification;
import com.fasc.open.api.bean.req.corp.*;
import com.fasc.open.api.bean.res.common.UrlRes;
import com.fasc.open.api.bean.res.corp.*;
import com.fasc.open.api.enums.common.AuthScopeEnum;
import com.fasc.open.api.enums.common.NotifyWayEnum;
import com.fasc.open.api.enums.corp.OperatorTypeEnum;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.utils.ResultUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Fadada
 * 2021/9/16 14:42:56
 */
public class CorpClientTest extends BaseTest {


    private static String clientCorpId = "corp-1631775421032";

    public static void main(String[] args) throws ApiException {
//        add();
//        update();
//        getDetail();
//        delete();
//        generateIdentifyUrl();
//        getIdentityProgress();
//        generateAuthUrl();
//        getAuthToken();
//        getIdentityInfo();

    }


    public static void add() throws ApiException {
        AddCorpReq addCorpReq = new AddCorpReq();
        addCorpReq.setAccessToken(accessToken);
        addCorpReq.setClientCorpId("corp-001");
        addCorpReq.setClientCorpName("辉哥开发环境企业");
        BaseRes<AddOpenCorpRes> res = corpClient.add(addCorpReq);
        openCorpId = res.getData().getOpenCorpId();
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }


    public static void update() throws ApiException {
        UpdateCorpReq updateCorpReq = new UpdateCorpReq();
        updateCorpReq.setAccessToken(accessToken);
        updateCorpReq.setOpenCorpId(openCorpId);
        updateCorpReq.setClientCorpId("corp-" + System.currentTimeMillis());
        updateCorpReq.setClientCorpName("辉哥开发企业");
        BaseRes<Void> res = corpClient.update(updateCorpReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }


    public static void delete() throws ApiException {
        DeleteCorpReq deleteCorpReq = new DeleteCorpReq();
        deleteCorpReq.setAccessToken(accessToken);
        deleteCorpReq.setOpenCorpId(openCorpId);
        BaseRes<Void> res = corpClient.delete(deleteCorpReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }


    public static void getDetail() throws ApiException {
        GetCorpDetailReq getCorpDetailReq = new GetCorpDetailReq();
        getCorpDetailReq.setAccessToken(accessToken);
        getCorpDetailReq.setAccessTokenAndClientToken(accessToken, clientToken);
        getCorpDetailReq.setOpenCorpId(openCorpId);
        BaseRes<CorpDetailRes> res = corpClient.getDetail(getCorpDetailReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void generateIdentifyUrl() throws ApiException {
        GenerateCorpIdentifyUrlReq generateCorpIdentifyUrlReq = new GenerateCorpIdentifyUrlReq();
        generateCorpIdentifyUrlReq.setAccessToken(accessToken);
        CorpIdentInfo corpIdentInfo = new CorpIdentInfo();
        corpIdentInfo.setCorpName("辉哥测试企业V5");
        Notification notification = new Notification();
        notification.setSendNotification(false);
        notification.setNotifyAddress("15313155104");
        notification.setNotifyWay(NotifyWayEnum.MOBILE.getCode());

        generateCorpIdentifyUrlReq.setCorpIdentInfo(corpIdentInfo);
        generateCorpIdentifyUrlReq.setOpenCorpId(openCorpId);
        generateCorpIdentifyUrlReq.setOperatorId(openUserId);
        generateCorpIdentifyUrlReq.setOperatorType(OperatorTypeEnum.LEGAL_PERSON.getCode());
        generateCorpIdentifyUrlReq.setNotification(notification);
        BaseRes<UrlRes> res = corpClient.generateIdentifyUrl(generateCorpIdentifyUrlReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }


    public static void getIdentityProgress() throws ApiException {
        GetCorpIdentityProgressReq getCorpIdentityProgressReq = new GetCorpIdentityProgressReq();
        getCorpIdentityProgressReq.setAccessToken(accessToken);
        getCorpIdentityProgressReq.setOpenCorpId(openCorpId);
        BaseRes<CorpIdentityProgressRes> res = corpClient.getIdentityProgress(getCorpIdentityProgressReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void getIdentityInfo() throws ApiException {
        GetCorpIdentityInfoReq getCorpIdentityInfoReq = new GetCorpIdentityInfoReq();
        getCorpIdentityInfoReq.setAccessToken(accessToken);
        getCorpIdentityInfoReq.setClientToken(clientToken);
        BaseRes<CorpIdentityInfoRes> res = corpClient.getIdentityInfo(getCorpIdentityInfoReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void generateAuthUrl() throws ApiException {
        GenerateCorpAuthUrlReq generateCorpAuthUrlReq = new GenerateCorpAuthUrlReq();
        generateCorpAuthUrlReq.setAccessToken(accessToken);
        generateCorpAuthUrlReq.setOpenCorpId(openCorpId);
        List<Integer> requestAuthScope = new ArrayList<>();
        requestAuthScope.add(AuthScopeEnum.SIGN_TASK_CREATE_AND_MAINTAIN.getCode());
        requestAuthScope.add(AuthScopeEnum.REAL_NAME_INFO.getCode());
        generateCorpAuthUrlReq.setRedirectUrl("http://www.baidu.com");
        generateCorpAuthUrlReq.setRequestAuthScope(requestAuthScope);

        BaseRes<UrlRes> res = corpClient.generateAuthUrl(generateCorpAuthUrlReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void getAuthToken() throws ApiException {
        GetCorpAuthTokenReq getCorpAuthTokenReq = new GetCorpAuthTokenReq();
        getCorpAuthTokenReq.setAccessToken(accessToken);
        getCorpAuthTokenReq.setAuthCode("9fcc276019b34b18bebbddc362790b50");
        BaseRes<CorpAuthTokenRes> res = corpClient.getAuthToken(getCorpAuthTokenReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }


}
