import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.req.doc.DocUploadReq;
import com.fasc.open.api.bean.req.doc.FileUploadReq;
import com.fasc.open.api.bean.res.doc.DocUploadRes;
import com.fasc.open.api.bean.res.doc.FileUploadRes;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.utils.ResultUtil;

import java.io.File;

/**
 * @author Fadada
 * 2021/9/16 10:23:20
 */
public class DocClientTest extends BaseTest {

    public static void main(String[] args) throws ApiException {
        docUpload();
//        attachUpload();
    }

    public static void docUpload() throws ApiException {
//        File file = new File("D:\\Desktop\\demo.pdf");
        File file = null;
        DocUploadReq docUploadReq = new DocUploadReq();
        docUploadReq.setAccessTokenAndClientToken(accessToken, clientToken);
        long start = System.currentTimeMillis();
        docUploadReq.setDocUrl("http://127.0.0.0:8989/getMsg");
        docUploadReq.setDocName("测试demo");
        BaseRes<DocUploadRes> docUploadResBaseRes = docClient.docUpload(file, docUploadReq);
        System.out.println("请求耗时" + (System.currentTimeMillis() - start));
        ResultUtil.checkResult(docUploadResBaseRes, openApiClient.getJsonStrategy());

    }

    public static void attachUpload() throws ApiException {
        File file = new File("D:\\Desktop\\2.pdf");
        FileUploadReq fileUploadReq = new FileUploadReq();
        fileUploadReq.setAccessTokenAndClientToken(accessToken, clientToken);
        fileUploadReq.setFileName("附件");
        BaseRes<FileUploadRes> attachUploadResBaseRes = docClient.fileUpload(file, fileUploadReq);
        ResultUtil.checkResult(attachUploadResBaseRes, openApiClient.getJsonStrategy());
    }
}
