import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.req.doctemplate.DocTemplateDetailReq;
import com.fasc.open.api.bean.req.doctemplate.DocTemplateListOnAppReq;
import com.fasc.open.api.bean.req.doctemplate.DocTemplateListOnClientFilterInfo;
import com.fasc.open.api.bean.req.doctemplate.DocTemplateListOnClientReq;
import com.fasc.open.api.bean.res.doctemplate.DocTemplateDetailRes;
import com.fasc.open.api.bean.res.doctemplate.DocTemplateListRes;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.utils.ResultUtil;

/**
 * @author Fadada
 * 2021/9/16 14:41:27
 */
public class DocTemplateClientTest extends BaseTest {

    //    private static String docTemplateId = "1634795906287117460";
    private static String docTemplateId = "1634972070302185500";

    public static void main(String[] args) throws ApiException {
        docTempalteListOnClient();
        docTempalteListOnApp();
        docTempalteDetail();
    }

    public static void docTempalteListOnClient() throws ApiException {
        DocTemplateListOnClientReq docTemplateListOnClientReq = new DocTemplateListOnClientReq();
        docTemplateListOnClientReq.setAccessTokenAndClientToken(accessToken, clientToken);
        docTemplateListOnClientReq.setListPageSize(5);
        docTemplateListOnClientReq.setListPageNo(1);
        DocTemplateListOnClientFilterInfo docTemplateListOnClientFilterInfo = new DocTemplateListOnClientFilterInfo();
        docTemplateListOnClientFilterInfo.setDocTemplateName("API");
//        docTemplateListOnClientReq.setListFilter(docTemplateListOnClientFilterInfo);
        BaseRes<DocTemplateListRes> docTemplateListResBaseRes = docTemplateClient.getListOnClient(docTemplateListOnClientReq);
        ResultUtil.checkResult(docTemplateListResBaseRes, openApiClient.getJsonStrategy());
    }

    public static void docTempalteListOnApp() throws ApiException {
        DocTemplateListOnAppReq docTemplateListOnAppReq = new DocTemplateListOnAppReq();
        docTemplateListOnAppReq.setAccessTokenAndClientToken(accessToken, clientToken);
        docTemplateListOnAppReq.setListPageSize(5);
        docTemplateListOnAppReq.setListPageNo(1);
        BaseRes<DocTemplateListRes> docTemplateListResBaseRes = docTemplateClient.getListOnApp(docTemplateListOnAppReq);
        ResultUtil.checkResult(docTemplateListResBaseRes, openApiClient.getJsonStrategy());
    }


    public static void docTempalteDetail() throws ApiException {
        DocTemplateDetailReq docTemplateDetailReq = new DocTemplateDetailReq();
        docTemplateDetailReq.setAccessTokenAndClientToken(accessToken, clientToken);
        docTemplateDetailReq.setDocTemplateId(docTemplateId);
        BaseRes<DocTemplateDetailRes> docTemplateDetailResBaseRes = docTemplateClient.getDetail(docTemplateDetailReq);
        ResultUtil.checkResult(docTemplateDetailResBaseRes, openApiClient.getJsonStrategy());
    }

}
