import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.base.BaseResponseEntity;
import com.fasc.open.api.bean.common.Actor;
import com.fasc.open.api.bean.common.ActorUser;
import com.fasc.open.api.bean.req.signtask.*;
import com.fasc.open.api.bean.res.common.UrlRes;
import com.fasc.open.api.bean.res.signtask.AddAttachsRes;
import com.fasc.open.api.bean.res.signtask.AddDocsRes;
import com.fasc.open.api.bean.res.signtask.CreateSignTaskRes;
import com.fasc.open.api.bean.res.signtask.SignTaskDetailRes;
import com.fasc.open.api.enums.signtask.ActorTypeEnum;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.utils.ResultUtil;
import com.fasc.open.api.utils.file.FileUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Fadada
 * 2021/9/16 15:50:24
 */
public class SignTaskClientTest extends BaseTest {


    private static String signTaskId = "1634729142089119557";

    public static void main(String[] args) throws ApiException {
//        createWithDocs();
//        createWithTemplate();
//        generateFieldsEditUrl();
//        unblock();
//        generateActorUserUrl();
        downloadDocs();
//        getDocUrl();
//        getDetail();


    }

    public static void createWithDocs() throws ApiException {
        CreateWithDocsReq createWithDocsReq = new CreateWithDocsReq();
        createWithDocsReq.setAccessTokenAndClientToken(accessToken, clientToken);

        String signTaskSubject = "测试";
        Integer signTaskAction = 1;

        List<CreateWithDocsDocmentInfo> docs = new ArrayList<>();

        CreateWithDocsDocmentInfo docmentInfo = new CreateWithDocsDocmentInfo();
        docmentInfo.setDocFileId("1631780471254126174");
        docmentInfo.setDocNo(1);
        docs.add(docmentInfo);

        List<SignTaskCcActorInfo> ccActors = new ArrayList<>();
        List<CreateWithDocsFillActorInfo> fillActors = new ArrayList<>();
        List<CreateWithDocsSignActorInfo> signActors = new ArrayList<>();


        ActorUser actorUser = new ActorUser();
        actorUser.setActorUserId(openUserId);
        Actor fillActor = new Actor();
        fillActor.setActorUser(actorUser);
        fillActor.setActorType(ActorTypeEnum.FILL_ACTOR.getCode());

        Actor signActor = new Actor();
        signActor.setActorUser(actorUser);
        signActor.setActorType(ActorTypeEnum.SIGN_ACTOR.getCode());

        CreateWithDocsFillActorInfo createWithDocsFillActorInfo = new CreateWithDocsFillActorInfo();
        createWithDocsFillActorInfo.setFillActor(fillActor);
        fillActors.add(createWithDocsFillActorInfo);

        CreateWithDocsSignActorInfo createWithDocsSignActorInfo = new CreateWithDocsSignActorInfo();
        createWithDocsSignActorInfo.setSignActor(signActor);
        signActors.add(createWithDocsSignActorInfo);

        createWithDocsReq.setFillActors(fillActors);
        createWithDocsReq.setSignActors(signActors);

        createWithDocsReq.setSignTaskSubject(signTaskSubject);
        createWithDocsReq.setDocs(docs);

        BaseRes<CreateSignTaskRes> res = signTaskClient.createWithDocs(createWithDocsReq);
        signTaskId = res.getData().getSignTaskId();
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }


    public static void createWithTemplate() throws ApiException {
        CreateWithTemplateReq createWithTemplateReq = new CreateWithTemplateReq();
        createWithTemplateReq.setAccessTokenAndClientToken(accessToken, clientToken);
        createWithTemplateReq.setSignTaskSubject("测试");


        String signTaskSubject = "";
        Integer signTaskAction = 1;
        List<CreateAttachInfo> attachs = new ArrayList<>();

        String signTemplateId = "465465456645L";

        List<SignTaskCcActorInfo> ccActors = new ArrayList<>();
        List<CreateWithTemplateFillActorInfo> fillActors = new ArrayList<>();
        List<CreateWithTemplateSignActorInfo> signActors = new ArrayList<>();

        ActorUser actorUser = new ActorUser();
        actorUser.setActorUserId(openUserId);

        Actor fillActor = new Actor();
        fillActor.setActorUser(actorUser);
        fillActor.setActorType(ActorTypeEnum.FILL_ACTOR.getCode());

        Actor signActor = new Actor();
        signActor.setActorUser(actorUser);
        signActor.setActorType(ActorTypeEnum.SIGN_ACTOR.getCode());


        CreateWithTemplateFillActorInfo createWithTemplateFillActorInfo = new CreateWithTemplateFillActorInfo();
        createWithTemplateFillActorInfo.setFillActor(fillActor);
        fillActors.add(createWithTemplateFillActorInfo);

        CreateWithTemplateSignActorInfo createWithTemplateSignActorInfo = new CreateWithTemplateSignActorInfo();
        createWithTemplateSignActorInfo.setSignActor(signActor);
        signActors.add(createWithTemplateSignActorInfo);

        createWithTemplateReq.setSignActors(signActors);
        createWithTemplateReq.setFillActors(fillActors);

        createWithTemplateReq.setSignTemplateId(signTemplateId);
        createWithTemplateReq.setSignTaskSubject(signTaskSubject);

        BaseRes<CreateSignTaskRes> res = signTaskClient.createWithTemplate(createWithTemplateReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }


    public static void addActors() throws ApiException {
        AddActorsReq addActorsReq = new AddActorsReq();
        addActorsReq.setAccessTokenAndClientToken(accessToken, clientToken);
        addActorsReq.setSignTaskId("");
        BaseRes<Void> res = signTaskClient.addActors(addActorsReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void delActor() throws ApiException {
        DeleteActorReq deleteActorReq = new DeleteActorReq();
        deleteActorReq.setAccessTokenAndClientToken(accessToken, clientToken);
        deleteActorReq.setSignTaskId("");
        BaseRes<Void> res = signTaskClient.deleteActor(deleteActorReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void addDocs() throws ApiException {
        AddDocsReq addDocsReq = new AddDocsReq();
        addDocsReq.setAccessTokenAndClientToken(accessToken, clientToken);
        addDocsReq.setSignTaskId("");
        BaseRes<AddDocsRes> res = signTaskClient.addDocs(addDocsReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void deleteDocs() throws ApiException {
        DeleteDocsReq deleteDocsReq = new DeleteDocsReq();
        deleteDocsReq.setAccessTokenAndClientToken(accessToken, clientToken);
        deleteDocsReq.setSignTaskId("");
        BaseRes<Void> res = signTaskClient.deleteDocs(deleteDocsReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void addAttachs() throws ApiException {
        AddAttachsReq addAttachsReq = new AddAttachsReq();
        addAttachsReq.setAccessTokenAndClientToken(accessToken, clientToken);
        addAttachsReq.setSignTaskId("");
        BaseRes<AddAttachsRes> res = signTaskClient.addAttachs(addAttachsReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void deleteAttachs() throws ApiException {
        DeleteAttachsReq deleteAttachsReq = new DeleteAttachsReq();
        deleteAttachsReq.setAccessTokenAndClientToken(accessToken, clientToken);
        deleteAttachsReq.setSignTaskId("");
        BaseRes<Void> res = signTaskClient.deleteAttachs(deleteAttachsReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void getDetail() throws ApiException {
        SignTaskBaseReq signTaskBaseReq = new SignTaskBaseReq();
        signTaskBaseReq.setAccessTokenAndClientToken(accessToken, clientToken);
        signTaskBaseReq.setSignTaskId(signTaskId);
        BaseRes<SignTaskDetailRes> res = signTaskClient.getDetail(signTaskBaseReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void initiate() throws ApiException {
        SignTaskBaseReq signTaskBaseReq = new SignTaskBaseReq();
        signTaskBaseReq.setAccessTokenAndClientToken(accessToken, clientToken);
        signTaskBaseReq.setSignTaskId("");
        BaseRes<Void> res = signTaskClient.initiate(signTaskBaseReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void finish() throws ApiException {
        SignTaskBaseReq signTaskBaseReq = new SignTaskBaseReq();
        signTaskBaseReq.setAccessTokenAndClientToken(accessToken, clientToken);
        signTaskBaseReq.setSignTaskId("");
        BaseRes<Void> res = signTaskClient.finish(signTaskBaseReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void finalizeDocs() throws ApiException {
        SignTaskBaseReq signTaskBaseReq = new SignTaskBaseReq();
        signTaskBaseReq.setAccessTokenAndClientToken(accessToken, clientToken);
        signTaskBaseReq.setSignTaskId("");
        BaseRes<Void> res = signTaskClient.finalizeDocs(signTaskBaseReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void unblock() throws ApiException {
        UnblockReq unblockReq = new UnblockReq();
        unblockReq.setAccessTokenAndClientToken(accessToken, clientToken);
        unblockReq.setSignTaskId("df");
        unblockReq.setActorId("");
        unblockReq.setActorType(1);
        BaseRes<Void> res = signTaskClient.unblock(unblockReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void cancel() throws ApiException {
        SignTaskBaseReq signTaskBaseReq = new SignTaskBaseReq();
        signTaskBaseReq.setAccessTokenAndClientToken(accessToken, clientToken);
        signTaskBaseReq.setSignTaskId("");
        BaseRes<Void> res = signTaskClient.cancel(signTaskBaseReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void generateActorUserUrl() throws ApiException {
        GenerateActorUserUrlReq generateActorUserUrlReq = new GenerateActorUserUrlReq();
        generateActorUserUrlReq.setAccessTokenAndClientToken(accessToken, clientToken);
        generateActorUserUrlReq.setSignTaskId(signTaskId);
        generateActorUserUrlReq.setActorUserId(openUserId);
        BaseRes<UrlRes> res = signTaskClient.generateActorUserUrl(generateActorUserUrlReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void generateFieldsEditUrl() throws ApiException {
        GenerateFieldsEditUrlReq generateFieldsEditUrlReq = new GenerateFieldsEditUrlReq();
        generateFieldsEditUrlReq.setAccessTokenAndClientToken(accessToken, clientToken);
        ActorUser actorUser = new ActorUser();
        actorUser.setActorUserId(openUserId);
        generateFieldsEditUrlReq.setSignTaskId(signTaskId);
        BaseRes<UrlRes> res = signTaskClient.generateFieldsEditUrl(generateFieldsEditUrlReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }


    public static void downloadDocs() throws ApiException {
        DownloadDocsReq downloadDocsReq = new DownloadDocsReq();
        downloadDocsReq.setAccessTokenAndClientToken(accessToken, clientToken);
//        downloadDocsReq.setFileNo(1);
        downloadDocsReq.setSignTaskId(signTaskId);
        BaseRes<BaseResponseEntity> res = signTaskClient.downloadDocs(downloadDocsReq);
        if (res.isSuccess()) {
            FileUtil.fileSink(res.getData().getContent(), "D:\\文件下载\\", "sdf121.zip");
        } else {
            ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
        }
    }


}
