import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.req.signtemplate.SignTemplateDetailReq;
import com.fasc.open.api.bean.req.signtemplate.SignTemplateListOnAppReq;
import com.fasc.open.api.bean.req.signtemplate.SignTemplateListOnClientFilterInfo;
import com.fasc.open.api.bean.req.signtemplate.SignTemplateListOnClientReq;
import com.fasc.open.api.bean.res.signtemplate.SignTemplateDetailRes;
import com.fasc.open.api.bean.res.signtemplate.SignTemplateListRes;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.utils.ResultUtil;

/**
 * @author Fadada
 * 2021/9/16 14:12:01
 */
public class SignTemplateClientTest extends BaseTest {

    private static String signTemplateId = "1634972004107180757";

    public static void main(String[] args) throws ApiException {
        signTempalteListOnClient();
        signTempalteListOnApp();
        signTempalteDetail();
    }

    public static void signTempalteListOnClient() throws ApiException {
        SignTemplateListOnClientReq signTemplateListOnClientReq = new SignTemplateListOnClientReq();
        signTemplateListOnClientReq.setAccessTokenAndClientToken(accessToken, clientToken);
        signTemplateListOnClientReq.setListPageSize(5);
        signTemplateListOnClientReq.setListPageNo(1);
        SignTemplateListOnClientFilterInfo signTemplateListOnClientFilterInfo = new SignTemplateListOnClientFilterInfo();
        signTemplateListOnClientFilterInfo.setSignTemplateName("API");
//        signTemplateListOnClientReq.setListFilter(signTemplateListOnClientFilterInfo);
        BaseRes<SignTemplateListRes> signTemplateListResBaseRes = signTemplateClient.getListOnClient(signTemplateListOnClientReq);
        ResultUtil.checkResult(signTemplateListResBaseRes, openApiClient.getJsonStrategy());
    }

    public static void signTempalteListOnApp() throws ApiException {
        SignTemplateListOnAppReq signTemplateListOnAppReq = new SignTemplateListOnAppReq();
        signTemplateListOnAppReq.setAccessTokenAndClientToken(accessToken, clientToken);
        signTemplateListOnAppReq.setListPageSize(5);
        signTemplateListOnAppReq.setListPageNo(1);
        BaseRes<SignTemplateListRes> signTemplateListResBaseRes = signTemplateClient.getListOnApp(signTemplateListOnAppReq);
        ResultUtil.checkResult(signTemplateListResBaseRes, openApiClient.getJsonStrategy());
    }


    public static void signTempalteDetail() throws ApiException {
        SignTemplateDetailReq signTemplateDetailReq = new SignTemplateDetailReq();
        signTemplateDetailReq.setAccessTokenAndClientToken(accessToken, clientToken);
        signTemplateDetailReq.setSignTemplateId(signTemplateId);
        BaseRes<SignTemplateDetailRes> signTemplateDetailResBaseRes = signTemplateClient.getDetail(signTemplateDetailReq);
        ResultUtil.checkResult(signTemplateDetailResBaseRes, openApiClient.getJsonStrategy());
    }

}
