import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.common.Notification;
import com.fasc.open.api.bean.common.UserIdentInfo;
import com.fasc.open.api.bean.req.user.*;
import com.fasc.open.api.bean.res.common.UrlRes;
import com.fasc.open.api.bean.res.user.*;
import com.fasc.open.api.enums.common.NotifyWayEnum;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.utils.ResultUtil;

/**
 * @author Fadada
 * 2021/9/16 14:42:56
 */
public class UserClientTest extends BaseTest {

    private static String clientUserId = "user-1631775421032";


    public static void main(String[] args) throws ApiException {

        add();
        update();
        getDetail();
//        delete();
        generateIdentifyUrl();
//        getIdentityProgress();
//        generateAuthUrl();
//        getAuthToken();
//        getIdentityInfo();


    }

    public static void add() throws ApiException {
        AddUserReq addUserReq = new AddUserReq();
        addUserReq.setAccessToken(accessToken);
        addUserReq.setClientUserId("user-00234");
        addUserReq.setClientUserName("辉哥哎34");
        BaseRes<AddOpenUserRes> res = userClient.add(addUserReq);

        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
        openUserId = res.getData().getOpenUserId();
    }


    public static void update() throws ApiException {
        UpdateUserReq updateUserReq = new UpdateUserReq();
        updateUserReq.setAccessToken(accessToken);
        updateUserReq.setOpenUserId(openUserId);
        updateUserReq.setClientUserId("user-" + System.currentTimeMillis());
        updateUserReq.setClientUserName("啦啦啦");
        BaseRes<Void> res = userClient.update(updateUserReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }


    public static void delete() throws ApiException {
        DeleteUserReq deleteUserReq = new DeleteUserReq();
        deleteUserReq.setAccessToken(accessToken);
        deleteUserReq.setOpenUserId(openUserId);
        BaseRes<Void> res = userClient.delete(deleteUserReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }


    public static void getDetail() throws ApiException {
        GetUserDetailReq getUserDetailReq = new GetUserDetailReq();
        getUserDetailReq.setAccessToken(accessToken);
        getUserDetailReq.setOpenUserId(openUserId);
        BaseRes<UserDetailRes> res = userClient.getDetail(getUserDetailReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void generateIdentifyUrl() throws ApiException {
        GenerateUserIdentifyUrlReq generateUserIdentifyUrlReq = new GenerateUserIdentifyUrlReq();
        generateUserIdentifyUrlReq.setAccessToken(accessToken);
        UserIdentInfo userIdentInfo = new UserIdentInfo();
        userIdentInfo.setUserName("");
        Notification notification = new Notification();
        notification.setSendNotification(false);
        notification.setNotifyAddress("15313155104");
        notification.setNotifyWay(NotifyWayEnum.MOBILE.getCode());

        generateUserIdentifyUrlReq.setUserIdentInfo(userIdentInfo);
        generateUserIdentifyUrlReq.setOpenUserId(openUserId);
        generateUserIdentifyUrlReq.setNotification(notification);
        BaseRes<UrlRes> res = userClient.generateIdentifyUrl(generateUserIdentifyUrlReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }


    public static void getIdentityProgress() throws ApiException {
        GetUserIdentityProgressReq getUserIdentityProgressReq = new GetUserIdentityProgressReq();
        getUserIdentityProgressReq.setAccessToken(accessToken);
        getUserIdentityProgressReq.setOpenUserId(openUserId);
        BaseRes<UserIdentityProgressRes> res = userClient.getIdentityProgress(getUserIdentityProgressReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void getIdentityInfo() throws ApiException {
        GetUserIdentityInfoReq getUserIdentityInfoReq = new GetUserIdentityInfoReq();
        getUserIdentityInfoReq.setAccessToken(accessToken);
        getUserIdentityInfoReq.setClientToken(clientToken);
        BaseRes<UserIdentityInfoRes> res = userClient.getIdentityInfo(getUserIdentityInfoReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void generateAuthUrl() throws ApiException {
        GenerateUserAuthUrlReq generateUserAuthUrlReq = new GenerateUserAuthUrlReq();
        generateUserAuthUrlReq.setAccessToken(accessToken);
        generateUserAuthUrlReq.setOpenUserId(openUserId);
        generateUserAuthUrlReq.setRedirectUrl("http://www.baidu.com");
        BaseRes<UrlRes> res = userClient.generateAuthUrl(generateUserAuthUrlReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

    public static void getAuthToken() throws ApiException {
        GetUserAuthTokenReq getUserAuthTokenReq = new GetUserAuthTokenReq();
        getUserAuthTokenReq.setAccessToken(accessToken);
        getUserAuthTokenReq.setAuthCode("");
        BaseRes<UserAuthTokenRes> res = userClient.getAuthToken(getUserAuthTokenReq);
        ResultUtil.checkResult(res, openApiClient.getJsonStrategy());
    }

}
