/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.client;

import com.fasc.open.api.bean.base.BaseReq;
import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.base.BaseResponseEntity;
import com.fasc.open.api.config.HttpConfig;
import com.fasc.open.api.enums.http.SignTypeEnum;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.stratey.DefaultJsonStrategy;
import com.fasc.open.api.stratey.JsonStrategy;
import com.fasc.open.api.utils.crypt.FddCryptUtil;
import com.fasc.open.api.utils.http.HttpUtil;
import com.fasc.open.api.utils.json.ParameterizedTypeBaseRes;
import com.fasc.open.api.utils.random.UUIDGenerator;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiClient {
    private final Logger log = LoggerFactory.getLogger(OpenApiClient.class);
    private final String appId;
    private final String appSecret;
    private final String serverUrl;
    private String signType = SignTypeEnum.HMAC_SHA256.getType();
    private JsonStrategy jsonStrategy;
    private HttpConfig httpConfig;

    public OpenApiClient(String appId, String appSecret, String serverUrl) {
        this.appId = appId;
        this.appSecret = appSecret;
        this.serverUrl = serverUrl;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        if (httpConfig != null) {
            HttpUtil.httpConfig = this.httpConfig = httpConfig;
        }
    }

    public String getSignType() {
        return this.signType;
    }

    public void setSignType(String signType) {
        if (signType != null) {
            this.signType = signType;
        }
    }

    public void setJsonStrategy(JsonStrategy jsonStrategy) {
        if (jsonStrategy != null) {
            this.jsonStrategy = jsonStrategy;
        }
    }

    public JsonStrategy getJsonStrategy() {
        if (this.jsonStrategy == null) {
            this.jsonStrategy = new DefaultJsonStrategy();
        }
        return this.jsonStrategy;
    }

    String invokeApi(BaseReq req, String path) throws ApiException {
        return this.httpRequest(req, path, null);
    }

    <T> BaseRes<T> invokeApi(BaseReq req, String path, Class<T> clzz) throws ApiException {
        return this.httpRequest(req, path, null, clzz);
    }

    <T> BaseRes<List<T>> invokeApiList(BaseReq req, String path, Class<T> clzz) throws ApiException {
        return this.httpRequestList(req, path, clzz);
    }

    String invokeApi(BaseReq req, String path, Map<String, File> files) throws ApiException {
        return this.httpRequest(req, path, files);
    }

    <T> BaseRes<T> invokeApi(BaseReq req, String path, Map<String, File> files, Class<T> clzz) throws ApiException {
        return this.httpRequest(req, path, files, clzz);
    }

    BaseRes<BaseResponseEntity> invokeApiDownload(BaseReq req, String path) throws ApiException {
        BaseRes res;
        String accessToken = req.getAccessToken();
        String clientToken = req.getClientToken();
        HashMap<String, String> bodyMap = this.getBodyMap(req);
        Map<String, String> headerMap = this.getSign(this.getHeaderMap(accessToken, clientToken), bodyMap);
        String method = this.getMethod(path);
        path = path.replace(method, "").trim();
        String url = this.serverUrl + path;
        BaseResponseEntity baseResponseEntity = this.request(url, headerMap, bodyMap);
        if (Boolean.TRUE.equals(baseResponseEntity.getSuccess())) {
            res = new BaseRes();
            res.setData(baseResponseEntity);
        } else {
            res = this.getJsonStrategy().toJavaBean(baseResponseEntity.getData(), BaseRes.class);
        }
        return res;
    }

    private <T> BaseRes<List<T>> httpRequestList(BaseReq req, String path, Class<T> clzz) throws ApiException {
        String resultJson = this.httpRequest(req, path, null);
        BaseRes baseRes = this.getJsonStrategy().toJavaBean(resultJson, BaseRes.class);
        Object data = baseRes.getData();
        if (data != null) {
            String jsonStr = data instanceof String ? String.valueOf(data) : this.getJsonStrategy().toJson(data);
            List<T> lists = this.getJsonStrategy().toList(jsonStr, clzz);
            baseRes.setData(lists);
        }
        return baseRes;
    }

    private <T> BaseRes<T> httpRequest(BaseReq req, String path, Map<String, File> files, Class<T> clzz) throws ApiException {
        String resultJson = this.httpRequest(req, path, files);
        return (BaseRes)this.getJsonStrategy().toJavaBean(resultJson, new ParameterizedTypeBaseRes(clzz));
    }

    private String httpRequest(BaseReq req, String path, Map<String, File> files) throws ApiException {
        String accessToken = req == null ? null : req.getAccessToken();
        String clientToken = req == null ? null : req.getClientToken();
        HashMap<String, String> bodyMap = this.getBodyMap(req);
        Map<String, String> headerMap = this.getSign(this.getHeaderMap(accessToken, clientToken), bodyMap);
        String method = this.getMethod(path);
        path = path.replace(method, "").trim();
        String url = this.serverUrl + path;
        return this.request(url, method, headerMap, bodyMap, files);
    }

    private String getMethod(String path) {
        String method;
        if (path.startsWith("POST")) {
            method = "POST";
        } else if (path.startsWith("GET")) {
            method = "GET";
        } else {
            throw new IllegalArgumentException("path\u503c\u975e\u6cd5");
        }
        return method;
    }

    private Map<String, String> getSign(Map<String, String> headerMap, Map<String, String> bodyMap) {
        try {
            HashMap<String, String> signMap = new HashMap<String, String>(headerMap);
            if (null != bodyMap) {
                signMap.putAll(bodyMap);
            }
            String sortParam = FddCryptUtil.sortParameters(signMap);
            String sign = FddCryptUtil.sign(sortParam, headerMap.get("X-FASC-Timestamp"), this.appSecret);
            headerMap.put("X-FASC-Sign", sign);
        }
        catch (Exception e) {
            this.log.error("\u8ba1\u7b97\u7b7e\u540d\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        return headerMap;
    }

    private HashMap<String, String> getHeaderMap(String accessToken, String clientToken) {
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("X-FASC-App-Id", this.appId);
        paraMap.put("X-FASC-Sign-Type", this.signType);
        if (clientToken != null) {
            paraMap.put("X-FASC-ClientToken", clientToken);
        }
        if (accessToken != null) {
            paraMap.put("X-FASC-AccessToken", accessToken);
            paraMap.remove("bizContent");
        } else {
            paraMap.put("X-FASC-Grant-Type", "client_credential");
        }
        paraMap.put("X-FASC-Timestamp", String.valueOf(System.currentTimeMillis()));
        paraMap.put("X-FASC-Nonce", UUIDGenerator.getUuid());
        return paraMap;
    }

    private HashMap<String, String> getBodyMap(BaseReq req) throws ApiException {
        if (req == null) {
            return new HashMap<String, String>();
        }
        req.setAccessToken(null);
        req.setClientToken(null);
        String bizContent = this.getJsonStrategy().toJson(req);
        HashMap<String, String> bodyMap = new HashMap<String, String>(1);
        bodyMap.put("bizContent", bizContent);
        return bodyMap;
    }

    private String request(String url, String method, Map<String, String> headerMap, Map<String, String> bodyMap, Map<String, File> fileMap) throws ApiException {
        try {
            String result = "";
            if ("GET".equals(method)) {
                result = HttpUtil.get(url, headerMap, bodyMap);
            } else if ("POST".equals(method)) {
                result = HttpUtil.post(url, headerMap, bodyMap, fileMap);
            }
            return result;
        }
        catch (ApiException apie) {
            throw apie;
        }
        catch (Exception e) {
            this.log.error("http\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new ApiException("http\u8bf7\u6c42\u5931\u8d25");
        }
    }

    private BaseResponseEntity request(String url, Map<String, String> headerMap, Map<String, String> bodyMap) throws ApiException {
        try {
            return HttpUtil.downLoadFiles(url, headerMap, bodyMap);
        }
        catch (Exception e) {
            this.log.error("httpDownLoad\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new ApiException("httpDownLoad\u8bf7\u6c42\u5931\u8d25");
        }
    }
}

