/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.client;

import com.fasc.open.api.bean.base.BaseReq;
import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.bean.req.user.AddUserReq;
import com.fasc.open.api.bean.req.user.DeleteUserReq;
import com.fasc.open.api.bean.req.user.GenerateUserAuthUrlReq;
import com.fasc.open.api.bean.req.user.GenerateUserIdentifyUrlReq;
import com.fasc.open.api.bean.req.user.GetUserAuthTokenReq;
import com.fasc.open.api.bean.req.user.GetUserDetailReq;
import com.fasc.open.api.bean.req.user.GetUserIdentityInfoReq;
import com.fasc.open.api.bean.req.user.GetUserIdentityProgressReq;
import com.fasc.open.api.bean.req.user.UpdateUserReq;
import com.fasc.open.api.bean.res.common.UrlRes;
import com.fasc.open.api.bean.res.user.AddOpenUserRes;
import com.fasc.open.api.bean.res.user.UserAuthTokenRes;
import com.fasc.open.api.bean.res.user.UserDetailRes;
import com.fasc.open.api.bean.res.user.UserIdentityInfoRes;
import com.fasc.open.api.bean.res.user.UserIdentityProgressRes;
import com.fasc.open.api.client.OpenApiClient;
import com.fasc.open.api.exception.ApiException;

public class UserClient {
    private OpenApiClient openApiClient;

    public UserClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<AddOpenUserRes> add(AddUserReq req) throws ApiException {
        return this.openApiClient.invokeApi((BaseReq)req, "POST /user/add", AddOpenUserRes.class);
    }

    public BaseRes<Void> update(UpdateUserReq req) throws ApiException {
        return this.openApiClient.invokeApi((BaseReq)req, "POST /user/update", Void.class);
    }

    public BaseRes<Void> delete(DeleteUserReq req) throws ApiException {
        return this.openApiClient.invokeApi((BaseReq)req, "POST /user/delete", Void.class);
    }

    public BaseRes<UserDetailRes> getDetail(GetUserDetailReq req) throws ApiException {
        return this.openApiClient.invokeApi((BaseReq)req, "POST /user/get-detail", UserDetailRes.class);
    }

    public BaseRes<UrlRes> generateIdentifyUrl(GenerateUserIdentifyUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi((BaseReq)req, "POST /user/generate-identify-url", UrlRes.class);
    }

    public BaseRes<UserIdentityProgressRes> getIdentityProgress(GetUserIdentityProgressReq req) throws ApiException {
        return this.openApiClient.invokeApi((BaseReq)req, "POST /user/get-identity-progress", UserIdentityProgressRes.class);
    }

    public BaseRes<UrlRes> generateAuthUrl(GenerateUserAuthUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi((BaseReq)req, "POST /user/generate-auth-url", UrlRes.class);
    }

    public BaseRes<UserAuthTokenRes> getAuthToken(GetUserAuthTokenReq req) throws ApiException {
        return this.openApiClient.invokeApi((BaseReq)req, "POST /user/get-auth-token", UserAuthTokenRes.class);
    }

    public BaseRes<UserIdentityInfoRes> getIdentityInfo(GetUserIdentityInfoReq req) throws ApiException {
        return this.openApiClient.invokeApi((BaseReq)req, "POST /user/get-identity-info", UserIdentityInfoRes.class);
    }
}

