/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.utils.crypt;

import com.fasc.open.api.exception.ApiException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashFile {
    private static Logger log = LoggerFactory.getLogger(HashFile.class);
    private static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private HashFile() {
    }

    public static String getFileMd5(String filename) throws ApiException {
        try {
            return HashFile.getHash(filename, "MD5");
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u540dMD5\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new ApiException("\u6587\u4ef6\u540dMD5\u5931\u8d25");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileSha256(File file) throws ApiException {
        try (FileInputStream fis = new FileInputStream(file);){
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest md5 = MessageDigest.getInstance("SHA-256");
            while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
                md5.update(buffer, 0, numRead);
            }
            String string = HashFile.toHexString(md5.digest());
            return string;
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6SHA256\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new ApiException("\u6587\u4ef6SHA256\u5931\u8d25");
        }
    }

    public static String getFileSha256(String filename) throws ApiException {
        try {
            return HashFile.getHash(filename, "SHA-256");
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u540d\u79f0SHA256\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new ApiException("\u6587\u4ef6\u540d\u79f0SHA256\u5931\u8d25");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getHash(String fileName, String hashType) throws ApiException {
        try (FileInputStream fis = new FileInputStream(fileName);){
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest md5 = MessageDigest.getInstance(hashType);
            while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
                md5.update(buffer, 0, numRead);
            }
            String string = HashFile.toHexString(md5.digest());
            return string;
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u540d\u79f0\u83b7\u53d6Hash\u503c\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new ApiException("\u6587\u4ef6\u540d\u79f0\u83b7\u53d6Hash\u503c\u5931\u8d25");
        }
    }

    private static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }
}

