/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.utils.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    private FileUtil() {
    }

    public static void fileSink(byte[] fileBytes, String path, String fileName) {
        File f = new File(path + fileName);
        if (f.exists()) {
            log.warn("\u6587\u4ef6\u5df2\u5b58\u5728:{}", (Object)f.getAbsolutePath());
            return;
        }
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(f);
             BufferedOutputStream bw = new BufferedOutputStream(fos);){
            bw.write(fileBytes);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u5199\u5165\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }
}

