/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.utils.http;

import com.fasc.open.api.bean.base.BaseResponseEntity;
import com.fasc.open.api.config.HttpConfig;
import com.fasc.open.api.exception.ApiException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    public static HttpConfig httpConfig;
    private static Logger log;

    private HttpUtil() {
    }

    private static HttpGet getHttpGet(String url, Map<String, String> params, String encode) {
        StringBuilder buf = new StringBuilder(url);
        if (params != null) {
            String flag = url.indexOf(63) == -1 ? "?" : "&";
            for (Map.Entry<String, String> entry : params.entrySet()) {
                buf.append(flag);
                buf.append(entry.getKey());
                buf.append("=");
                try {
                    String param = entry.getValue();
                    if (param == null) {
                        param = "";
                    }
                    buf.append(URLEncoder.encode(param, encode));
                }
                catch (UnsupportedEncodingException e) {
                    log.error("URLEncoder Error,encode=" + encode + ",param=" + entry.getValue(), (Throwable)e);
                }
                flag = "&";
            }
        }
        return new HttpGet(buf.toString());
    }

    private static HttpPost getHttpPost(String url, Map<String, String> params, Map<String, File> files) {
        HttpPost httpPost = new HttpPost(url);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        if (files != null && !files.isEmpty()) {
            for (Map.Entry<String, Object> entry : files.entrySet()) {
                String fileName = ((File)entry.getValue()).getName();
                multipartEntityBuilder.addBinaryBody(entry.getKey(), (File)entry.getValue(), ContentType.create((String)"multipart/form-data", (Charset)Consts.UTF_8), fileName);
            }
        }
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = (String)entry.getValue();
                multipartEntityBuilder.addTextBody(key, value, ContentType.TEXT_PLAIN.withCharset("UTF-8"));
            }
            multipartEntityBuilder.setMode(HttpMultipartMode.RFC6532);
        }
        HttpEntity httpEntity = multipartEntityBuilder.build();
        httpPost.setEntity(httpEntity);
        return httpPost;
    }

    private static HttpPost getHttpPost(String url, Map<String, String> params, String charset) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        if (params != null && !params.isEmpty()) {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                BasicNameValuePair basicNameValuePair = new BasicNameValuePair(key, value);
                list.add(basicNameValuePair);
            }
            UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(list, charset);
            httpPost.setEntity((HttpEntity)httpEntity);
        }
        return httpPost;
    }

    public static String post(String url, Map<String, String> reqHeader, Map<String, String> params, Map<String, File> files) throws ApiException {
        try {
            CloseableHttpClient httpClient = HttpUtil.getHttpClient(httpConfig);
            HttpPost httpPost = files == null || files.isEmpty() ? HttpUtil.getHttpPost(url, params, "UTF-8") : HttpUtil.getHttpPost(url, params, files);
            httpPost.setConfig(HttpUtil.getRequestConfig(httpConfig));
            return HttpUtil.executeHttpRequest(httpClient, (HttpUriRequest)httpPost, reqHeader);
        }
        catch (ApiException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("url=[{}] http\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Object)url, (Object)e);
            throw new ApiException("\u8bf7\u6c42\u5931\u8d25");
        }
    }

    public static CloseableHttpClient getHttpClient(HttpConfig httpConfig) throws ApiException {
        if (httpConfig != null && Boolean.TRUE.equals(httpConfig.getProxyFlag())) {
            return HttpClients.custom().build();
        }
        try {
            SSLContext ctx = SSLContexts.custom().setProtocol("TLSv1.2").build();
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(ctx)).build();
        }
        catch (Exception e) {
            log.error("HttpClient\u751f\u6210\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new ApiException("HttpClient\u751f\u6210\u5931\u8d25");
        }
    }

    public static String get(String url, Map<String, String> reqHeader, Map<String, String> params) throws ApiException {
        CloseableHttpClient httpClient = HttpUtil.getHttpClient(httpConfig);
        HttpGet httpGet = HttpUtil.getHttpGet(url, params, "UTF-8");
        httpGet.setConfig(HttpUtil.getRequestConfig(httpConfig));
        return HttpUtil.executeHttpRequest(httpClient, (HttpUriRequest)httpGet, reqHeader);
    }

    public static String executeHttpRequest(CloseableHttpClient client, HttpUriRequest request, Map<String, String> reqHeader) throws ApiException {
        try {
            if (reqHeader != null && !reqHeader.isEmpty()) {
                for (Map.Entry<String, String> entry : reqHeader.entrySet()) {
                    request.addHeader(entry.getKey(), entry.getValue());
                }
            }
            CloseableHttpResponse response = client.execute(request);
            HttpUtil.reqesutAndResponseLog(request, (HttpResponse)response);
            if (response.getStatusLine().getStatusCode() != 200) {
                log.error("\u8bf7\u6c42\u5931\u8d25\u72b6\u6001\u7801\uff1a{}", (Object)response.getStatusLine().getStatusCode());
                throw new ApiException("\u8bf7\u6c42\u5931\u8d25");
            }
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (SocketTimeoutException eto) {
            log.error("\u8bf7\u6c42\u94fe\u63a5\u8d85\u65f6\uff1a{}", (Object)eto.getMessage());
            throw new ApiException("\u8bf7\u6c42\u8d85\u65f6");
        }
        catch (Exception e) {
            log.error("executeHttpRequest\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new ApiException("\u8bf7\u6c42\u5931\u8d25");
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    log.error("CloseableHttpClient\u5173\u95ed\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
            }
        }
    }

    public static BaseResponseEntity downLoadFiles(String url, Map<String, String> reqHeader, Map<String, String> params) throws ApiException {
        BaseResponseEntity entity = new BaseResponseEntity();
        CloseableHttpClient httpClient = HttpUtil.getHttpClient(httpConfig);
        try {
            HttpPost httpPost = HttpUtil.getHttpPost(url, params, "UTF-8");
            if (reqHeader != null) {
                for (Map.Entry<String, String> entry : reqHeader.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            httpPost.setConfig(HttpUtil.getRequestConfig(httpConfig));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpUtil.reqesutAndResponseLog((HttpUriRequest)httpPost, (HttpResponse)response);
            if (response.getStatusLine().getStatusCode() != 200) {
                log.error("\u8bf7\u6c42\u5931\u8d25\u72b6\u6001\u7801\uff1a{}", (Object)response.getStatusLine().getStatusCode());
                throw new ApiException("\u8bf7\u6c42\u5931\u8d25");
            }
            HttpEntity respEntity = response.getEntity();
            Header contentType = respEntity.getContentType();
            if (contentType.getValue().contains(ContentType.APPLICATION_JSON.getMimeType())) {
                entity.setSuccess(false);
                entity.setData(EntityUtils.toString((HttpEntity)respEntity));
            } else {
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                entity.setContent(bytes);
                entity.setContentType(contentType.getValue());
                entity.setSuccess(true);
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new ApiException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25");
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    log.error("CloseableHttpClient\u5173\u95ed\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
            }
        }
        return entity;
    }

    private static void reqesutAndResponseLog(HttpUriRequest request, HttpResponse response) {
        Header[] responseHeaders;
        Header[] requestHeaders;
        URI uri = request.getURI();
        if (uri != null) {
            log.info("request url = [{}]", (Object)uri.toString());
        }
        if ((requestHeaders = request.getHeaders("X-FASC-Nonce")) != null && requestHeaders.length > 0) {
            log.info("request header {}= [{}]", (Object)"X-FASC-Nonce", (Object)requestHeaders[0].getValue());
        }
        if ((responseHeaders = response.getHeaders("X-FASC-Request-Id")) != null && responseHeaders.length > 0) {
            log.info("response header {}= [{}]", (Object)"X-FASC-Request-Id", (Object)responseHeaders[0].getValue());
        }
    }

    private static RequestConfig getRequestConfig(HttpConfig httpConfig) {
        RequestConfig.Builder custom = RequestConfig.custom();
        if (httpConfig != null) {
            if (httpConfig.getReadTimeout() != null) {
                custom.setSocketTimeout(httpConfig.getReadTimeout().intValue());
            }
            if (httpConfig.getConnectTimeout() != null) {
                custom.setConnectTimeout(httpConfig.getConnectTimeout().intValue());
            }
            if (Boolean.TRUE.equals(httpConfig.getProxyFlag())) {
                HttpHost proxy = new HttpHost(httpConfig.getProxyHost(), httpConfig.getProxyPort().intValue(), "http");
                custom.setProxy(proxy);
            }
        }
        return custom.build();
    }

    static {
        log = LoggerFactory.getLogger(HttpUtil.class);
    }
}

