package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.v5_1.req.doc.FileProcessReq;
import com.fasc.open.api.v5_1.req.doc.FileVerifySignReq;
import com.fasc.open.api.v5_1.req.doc.GetUploadUrlReq;
import com.fasc.open.api.v5_1.req.doc.UploadFileByUrlReq;
import com.fasc.open.api.v5_1.res.doc.FileProcessRes;
import com.fasc.open.api.v5_1.res.doc.FileVerifySignRes;
import com.fasc.open.api.v5_1.res.doc.GetUploadUrlRes;
import com.fasc.open.api.v5_1.res.doc.UploadFileByUrlRes;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;

/**
 * @author Fadada
 * 2021/9/8 16:09:38
 */
public class DocClient {
    private OpenApiClient openApiClient;

    public DocClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<UploadFileByUrlRes> uploadFileByUrl(UploadFileByUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.FILE_UPLOAD_BY_URL, UploadFileByUrlRes.class);
    }

    public BaseRes<GetUploadUrlRes> getUploadFileUrl(GetUploadUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.FILE_GET_UPLOAD_URL, GetUploadUrlRes.class);
    }

    public BaseRes<FileProcessRes> process(FileProcessReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.FILE_PROCESS, FileProcessRes.class);
    }
    /** 文档验签 **/
    public BaseRes<FileVerifySignRes> fileVerifySign(FileVerifySignReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.DOC_POST_FILE_VERIFY_SIGN, FileVerifySignRes.class);
    }
}
