package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.req.callback.GetCallBackListReq;
import com.fasc.open.api.v5_1.res.callback.GetCallBackListRes;

/**
 * @author zhoufucheng
 * @date 2023/6/14 14:10
 */
public class CallBackClient {
    private OpenApiClient openApiClient;

    public CallBackClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<GetCallBackListRes> getCallBackList(GetCallBackListReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.GET_CALL_BACK_LIST, GetCallBackListRes.class);
    }
}
