package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.req.approval.GetApprovalDetailReq;
import com.fasc.open.api.v5_1.req.approval.GetApprovalInfoListReq;
import com.fasc.open.api.v5_1.req.approval.GetApprovalUrlReq;
import com.fasc.open.api.v5_1.res.approval.GetApprovalDetailRes;
import com.fasc.open.api.v5_1.res.approval.GetApprovalInfoListRes;
import com.fasc.open.api.v5_1.res.approval.GetApprovalUrlRes;

/**
 * @author Fadada
 * 2023/06/14 16:48:09
 */
public class ApproveClient {

    private OpenApiClient openApiClient;

    public ApproveClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }


    public BaseRes<GetApprovalUrlRes> approvalGetUrl(GetApprovalUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.APPROVAL_GET_URL, GetApprovalUrlRes.class);
    }

    public BaseRes<GetApprovalInfoListRes> approvalGetList(GetApprovalInfoListReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.APPROVAL_GET_LIST, GetApprovalInfoListRes.class);
    }

    public BaseRes<GetApprovalDetailRes> approvalGetDetail(GetApprovalDetailReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.APPROVAL_GET_DETAIL, GetApprovalDetailRes.class);
    }


}
