package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.constants.OpenApiUrlConstants;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.req.user.*;
import com.fasc.open.api.v5_1.res.common.EUrlRes;
import com.fasc.open.api.v5_1.res.user.*;

/**
 * @author Fadada
 * 2021/10/16 16:47:06
 */
public class UserClient {
    private OpenApiClient openApiClient;

    public UserClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<Void> disable(DisableUserReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_DISABLE, Void.class);
    }

    public BaseRes<Void> enable(EnableUserReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_ENABLE, Void.class);
    }

    public BaseRes<UserRes> get(GetUserReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_GET, UserRes.class);
    }

    public BaseRes<UserIdentityInfoRes> getIdentityInfo(GetUserIdentityInfoReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_GET_IDENTITY_INFO, UserIdentityInfoRes.class);
    }

    public BaseRes<Void> unbind(UserUnbindReq req) throws ApiException{
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_UNBIND, Void.class);
    }

    public BaseRes<EUrlRes> getUserAuthUrl(GetUserAuthUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_GET_AUTH_URL, EUrlRes.class);
    }

    public BaseRes<GetUserTransactionDetailRes> getUserIdentTransactionId(GetUserIdentTransactionIdReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_GET_IDENT_TRANSACTION_ID, GetUserTransactionDetailRes.class);
    }

    /** 获取三要素校验接口**/
    public BaseRes<GetUserThreeElementVerifyUrlReq> getUserThreeElementVerifyUrl(GetUserThreeElementVerifyUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_GET_THREE_ELEMENT_VERIFY_URL, GetUserThreeElementVerifyUrlReq.class);
    }
    /** 获取四要素校验接口**/
    public BaseRes<GetFourElementsVerifyUrlRes> getUserFourElementVerifyUrl(GetUserFourElementVerifyUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_GET_FOUR_ELEMENT_VERIFY_URL, GetFourElementsVerifyUrlRes.class);
    }

    /** 获取要素校验身份证图片下载链接**/
    public BaseRes<GetIdCardImageDownloadUrlRes> getUserIdcardImageDownloadUrl(GetIdCardImageDownloadUrlReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_GET_IDCARD_IMAGE_DOWNLOAD_URL, GetIdCardImageDownloadUrlRes.class);
    }

    /** 个人认证授权管理-身份证OCR**/
    public BaseRes<IdCardOcrRes> IdCardOcr(IdCardOcrReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.USER_GET_OCR_ID_CARD, IdCardOcrRes.class);
    }

    //个人二要素校验
    public BaseRes<IdentityTwoElementVerifyRes> identityTwoElementVerify(IdentityTwoElementVerifyReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.IDENTITY_TWO_ELEMENT_VERIFY, IdentityTwoElementVerifyRes.class);
    }

    //个人运营商三要素校验
    public BaseRes<TelecomThreeElementVerifyRes> telecomThereElementVerify(TelecomThreeElementVerifyReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.TELECOM_THREE_ELEMENT_VERIFY, TelecomThreeElementVerifyRes.class);
    }

    //个人银行卡四要素校验
    public BaseRes<BankFourElementVerifyRes> bankFourElementVerify(BankFourElementVerifyReq req) throws ApiException {
        return openApiClient.invokeApi(req, OpenApiUrlConstants.BANK_FOUR_ELEMENT_VERIFY, BankFourElementVerifyRes.class);
    }

}
