package com.fasc.open.api.utils;


import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.constants.RequestConstants;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.stratey.JsonStrategy;
import com.fasc.open.api.utils.crypt.FddCryptUtil;
import com.fasc.open.api.utils.json.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Fadada
 * 2021/9/8 16:09:38
 */
public class ResultUtil {

    private static final Logger log = LoggerFactory.getLogger(ResultUtil.class);

    private ResultUtil() {
    }

    /**
     * 打日志
     *
     * @param baseRes      响应base
     * @param jsonStrategy 策率
     * @throws ApiException 异常
     */
    public static void printLog(BaseRes baseRes, JsonStrategy jsonStrategy) throws ApiException {
        String json = null;

        if (baseRes != null) {
            json = jsonStrategy.toJson(baseRes);
        }

        if (baseRes != null && baseRes.isSuccess()) {
            log.info("请求成功：{}", json);
        } else {
            log.info("请求失败：{}", json);
        }
    }

    public static void main(String[] args) throws Exception {
        Map<String, String> sortParams = new HashMap<>();
        sortParams.put("appId", "CLOUD00077982");
        sortParams.put("actorId", "个人方");
        sortParams.put("signTaskId", "1688436949899148528");
        sortParams.put("openId", "oWPcX5bgaseZTpRTWAiLqCyEKSM00");
        sortParams.put("wxAppId", "CLOUD00077982");
        sortParams.put("subAppId", "wx9ffd7688c45b8a30");
        sortParams.put("spMchId", "1604079590");
        sortParams.put("subMchId", "1604079590");
        sortParams.put("authenticateNumber", "22052711510100000415");
        sortParams.put("token", "e8358804-a7d9-496f-b6c6-500acd421518-3005473");
        sortParams.put("userNamePlain", "解先生");
        sortParams.put("idCardNumberPlain", "440306199805207752");
        sortParams.put("path", "pages/person/inductionHandling/inductionHandling?tab=myContract");
        String timestamp = String.valueOf(System.currentTimeMillis());
        String signStr = FddCryptUtil.sign(FddCryptUtil.sortParameters(sortParams), timestamp, "OVCQVS2MELECLUPVG1XZ4MPUTRBEYBPE");
        sortParams.put(RequestConstants.EUI_SIGNATURE, signStr);
        sortParams.put(RequestConstants.EUI_TIMESTAMP, timestamp);
        System.out.println(JacksonUtil.toJson(sortParams));
    }

}
