/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.utils.crypt;

import com.fasc.open.api.exception.ApiException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashFile {
    private static Logger log = LoggerFactory.getLogger(HashFile.class);
    private static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private HashFile() {
    }

    public static String getFileMd5(String filename) throws ApiException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            String string = HashFile.getHash(fis, "MD5");
            return string;
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u540dMD5\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ApiException("\u6587\u4ef6\u540dMD5\u5931\u8d25");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.error("\u6587\u4ef6\u6d41\u5173\u95ed\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    public static String getFileMd5(File file) throws ApiException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            String string = HashFile.getHash(fis, "MD5");
            return string;
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6MD5\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ApiException("\u6587\u4ef6MD5\u5931\u8d25");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.error("\u6587\u4ef6\u6d41\u5173\u95ed\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    public static String getFileMd5(FileInputStream fis) throws ApiException {
        return HashFile.getHash(fis, "MD5");
    }

    public static String getFileMd5(byte[] dataBytes) throws ApiException {
        return HashFile.getHash(dataBytes, "MD5");
    }

    public static String getFileSha256(String filename) throws ApiException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            String string = HashFile.getHash(fis, "SHA-256");
            return string;
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u540d\u79f0SHA256\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ApiException("\u6587\u4ef6\u540d\u79f0SHA256\u5931\u8d25");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.error("\u6587\u4ef6\u6d41\u5173\u95ed\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    public static String getFileSha256(File file) throws ApiException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            String string = HashFile.getHash(fis, "SHA-256");
            return string;
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6SHA256\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ApiException("\u6587\u4ef6SHA256\u5931\u8d25");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.error("\u6587\u4ef6\u6d41\u5173\u95ed\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    public static String getFileSha256(FileInputStream fis) throws ApiException {
        return HashFile.getHash(fis, "SHA-256");
    }

    public static String getFileSha256(byte[] dataBytes) throws ApiException {
        return HashFile.getHash(dataBytes, "SHA-256");
    }

    private static String getHash(InputStream inputStream, String hashType) throws ApiException {
        MessageDigest messageDigest = null;
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            messageDigest = MessageDigest.getInstance(hashType);
            while ((numRead = inputStream.read(buffer)) > 0) {
                messageDigest.update(buffer, 0, numRead);
            }
            return HashFile.toHexString(messageDigest.digest());
        }
        catch (Exception e) {
            log.error("\u8f93\u5165\u6d41\u83b7\u53d6Hash\u503c\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ApiException("\u8f93\u5165\u6d41\u83b7\u53d6Hash\u503c\u5931\u8d25");
        }
    }

    private static String getHash(byte[] dataBytes, String hashType) throws ApiException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(hashType);
            return HashFile.toHexString(messageDigest.digest(dataBytes));
        }
        catch (Exception e) {
            log.error("\u5b57\u8282\u6570\u636e\u83b7\u53d6Hash\u503c\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new ApiException("\u5b57\u8282\u6570\u636e\u83b7\u53d6Hash\u503c\u5931\u8d25");
        }
    }

    private static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }
}

