/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.client.OpenApiClient;
import com.fasc.open.api.v5_1.req.org.CreateCorpDeptReq;
import com.fasc.open.api.v5_1.req.org.CreateCorpMemberReq;
import com.fasc.open.api.v5_1.req.org.DeleteCorpDeptReq;
import com.fasc.open.api.v5_1.req.org.DeleteCorpMemberReq;
import com.fasc.open.api.v5_1.req.org.GetCorpDeptDetailReq;
import com.fasc.open.api.v5_1.req.org.GetCorpDeptListReq;
import com.fasc.open.api.v5_1.req.org.GetCorpMemberActiveUrlReq;
import com.fasc.open.api.v5_1.req.org.GetCorpMemberDetailReq;
import com.fasc.open.api.v5_1.req.org.GetCorpOrgManageUrlReq;
import com.fasc.open.api.v5_1.req.org.GetEntityListReq;
import com.fasc.open.api.v5_1.req.org.GetMemberListReq;
import com.fasc.open.api.v5_1.req.org.ModifyCorpDeptReq;
import com.fasc.open.api.v5_1.req.org.ModifyCorpMemberReq;
import com.fasc.open.api.v5_1.req.org.SetCorpMemberDeptReq;
import com.fasc.open.api.v5_1.req.org.SetCorpMemberStatusReq;
import com.fasc.open.api.v5_1.res.org.CorpDeptInfo;
import com.fasc.open.api.v5_1.res.org.CreateCorpDeptRes;
import com.fasc.open.api.v5_1.res.org.GetCorpDeptDetailRes;
import com.fasc.open.api.v5_1.res.org.GetCorpMemberDetailRes;
import com.fasc.open.api.v5_1.res.org.GetCorpOrgManageUrlRes;
import com.fasc.open.api.v5_1.res.org.GetEntityListRes;
import com.fasc.open.api.v5_1.res.org.GetMemberListRes;
import com.fasc.open.api.v5_1.res.org.SimpleEmployeeInfo;
import java.util.List;

public class OrgClient {
    private OpenApiClient openApiClient;

    public OrgClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<List<CorpDeptInfo>> getCorpDeptList(GetCorpDeptListReq req) throws ApiException {
        return this.openApiClient.invokeApiList(req, "POST /corp/dept/get-list", CorpDeptInfo.class);
    }

    public BaseRes<GetCorpDeptDetailRes> getCorpDeptDetail(GetCorpDeptDetailReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/dept/get-detail", GetCorpDeptDetailRes.class);
    }

    public BaseRes<CreateCorpDeptRes> createCorpDept(CreateCorpDeptReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/dept/create", CreateCorpDeptRes.class);
    }

    public BaseRes<Void> modifyCorpDept(ModifyCorpDeptReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/dept/modify", Void.class);
    }

    public BaseRes<Void> deleteCorpDept(DeleteCorpDeptReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/dept/delete", Void.class);
    }

    public BaseRes<GetMemberListRes> getMemberList(GetMemberListReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/member/get-list", GetMemberListRes.class);
    }

    public BaseRes<GetCorpMemberDetailRes> getCorpMemberDetail(GetCorpMemberDetailReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/member/get-detail", GetCorpMemberDetailRes.class);
    }

    public BaseRes<List<SimpleEmployeeInfo>> createCorpMember(CreateCorpMemberReq req) throws ApiException {
        return this.openApiClient.invokeApiList(req, "POST /corp/member/create", SimpleEmployeeInfo.class);
    }

    public BaseRes<List<SimpleEmployeeInfo>> getCorpMemberActiveUrl(GetCorpMemberActiveUrlReq req) throws ApiException {
        return this.openApiClient.invokeApiList(req, "POST /corp/member/get-active-url", SimpleEmployeeInfo.class);
    }

    public BaseRes<Void> modifyCorpMember(ModifyCorpMemberReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/member/modify", Void.class);
    }

    public BaseRes<Void> setCorpMemberDept(SetCorpMemberDeptReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/member/set-dept", Void.class);
    }

    public BaseRes<Void> setCorpMemberStatus(SetCorpMemberStatusReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/member/set-status", Void.class);
    }

    public BaseRes<Void> deleteCorpMember(DeleteCorpMemberReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/member/delete", Void.class);
    }

    public BaseRes<GetCorpOrgManageUrlRes> getCorpOrgManageUrl(GetCorpOrgManageUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /corp/organization/manage/get-url", GetCorpOrgManageUrlRes.class);
    }

    public BaseRes<List<GetEntityListRes>> getCorpEntityList(GetEntityListReq req) throws ApiException {
        return this.openApiClient.invokeApiList(req, "POST /corp/entity/get-list", GetEntityListRes.class);
    }
}

