/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.client.OpenApiClient;
import com.fasc.open.api.v5_1.req.user.DisableUserReq;
import com.fasc.open.api.v5_1.req.user.EnableUserReq;
import com.fasc.open.api.v5_1.req.user.GetUserAuthUrlReq;
import com.fasc.open.api.v5_1.req.user.GetUserIdentTransactionIdReq;
import com.fasc.open.api.v5_1.req.user.GetUserIdentityInfoReq;
import com.fasc.open.api.v5_1.req.user.GetUserReq;
import com.fasc.open.api.v5_1.req.user.UserUnbindReq;
import com.fasc.open.api.v5_1.res.common.EUrlRes;
import com.fasc.open.api.v5_1.res.user.GetUserTransactionDetailRes;
import com.fasc.open.api.v5_1.res.user.UserIdentityInfoRes;
import com.fasc.open.api.v5_1.res.user.UserRes;

public class UserClient {
    private OpenApiClient openApiClient;

    public UserClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<Void> disable(DisableUserReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/disable", Void.class);
    }

    public BaseRes<Void> enable(EnableUserReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/enable", Void.class);
    }

    public BaseRes<UserRes> get(GetUserReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/get", UserRes.class);
    }

    public BaseRes<UserIdentityInfoRes> getIdentityInfo(GetUserIdentityInfoReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/get-identity-info", UserIdentityInfoRes.class);
    }

    public BaseRes<Void> unbind(UserUnbindReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/unbind", Void.class);
    }

    public BaseRes<EUrlRes> getUserAuthUrl(GetUserAuthUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/get-auth-url", EUrlRes.class);
    }

    public BaseRes<GetUserTransactionDetailRes> getUserIdentTransactionId(GetUserIdentTransactionIdReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /user/get-ident-transaction-id", GetUserTransactionDetailRes.class);
    }
}

