/*
 * Decompiled with CFR 0.152.
 */
package com.fasc.open.api.v5_1.client;

import com.fasc.open.api.bean.base.BaseRes;
import com.fasc.open.api.exception.ApiException;
import com.fasc.open.api.v5_1.client.OpenApiClient;
import com.fasc.open.api.v5_1.req.doc.FileProcessReq;
import com.fasc.open.api.v5_1.req.doc.FileVerifySignReq;
import com.fasc.open.api.v5_1.req.doc.GetKeywordPositionReq;
import com.fasc.open.api.v5_1.req.doc.GetUploadUrlReq;
import com.fasc.open.api.v5_1.req.doc.HtmlToPfdReq;
import com.fasc.open.api.v5_1.req.doc.OfdFileMergeReq;
import com.fasc.open.api.v5_1.req.doc.PfdFileMergeReq;
import com.fasc.open.api.v5_1.req.doc.UploadFileByUrlReq;
import com.fasc.open.api.v5_1.res.doc.FileProcessRes;
import com.fasc.open.api.v5_1.res.doc.FileVerifySignRes;
import com.fasc.open.api.v5_1.res.doc.GetKeywordPositionRes;
import com.fasc.open.api.v5_1.res.doc.GetUploadUrlRes;
import com.fasc.open.api.v5_1.res.doc.HtmlToPfdRes;
import com.fasc.open.api.v5_1.res.doc.OfdFileMergeRes;
import com.fasc.open.api.v5_1.res.doc.PfdFileMergeRes;
import com.fasc.open.api.v5_1.res.doc.UploadFileByUrlRes;
import java.util.List;

public class DocClient {
    private OpenApiClient openApiClient;

    public DocClient(OpenApiClient openApiClient) {
        this.openApiClient = openApiClient;
    }

    public BaseRes<UploadFileByUrlRes> uploadFileByUrl(UploadFileByUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /file/upload-by-url", UploadFileByUrlRes.class);
    }

    public BaseRes<GetUploadUrlRes> getUploadFileUrl(GetUploadUrlReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /file/get-upload-url", GetUploadUrlRes.class);
    }

    public BaseRes<FileProcessRes> process(FileProcessReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /file/process", FileProcessRes.class);
    }

    public BaseRes<FileVerifySignRes> fileVerifySign(FileVerifySignReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /file/verify-sign", FileVerifySignRes.class);
    }

    public BaseRes<List<GetKeywordPositionRes>> getKeywordPosition(GetKeywordPositionReq req) throws ApiException {
        return this.openApiClient.invokeApiList(req, "POST /file/get-keyword-positions", GetKeywordPositionRes.class);
    }

    public BaseRes<OfdFileMergeRes> ofdFileMerge(OfdFileMergeReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /file/ofd-file-merge", OfdFileMergeRes.class);
    }

    public BaseRes<PfdFileMergeRes> PfdFileMerge(PfdFileMergeReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /file/pdf-file-merge", PfdFileMergeRes.class);
    }

    public BaseRes<HtmlToPfdRes> htmlToPdf(HtmlToPfdReq req) throws ApiException {
        return this.openApiClient.invokeApi(req, "POST /file/html-to-pdf", HtmlToPfdRes.class);
    }
}

