/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flagsmith.FeatureUser;
import com.flagsmith.Flag;
import com.flagsmith.FlagsAndTraits;
import com.flagsmith.FlagsmithConfig;
import com.flagsmith.FlagsmithLogger;
import com.flagsmith.FlagsmithLoggerLevel;
import com.flagsmith.IdentityTraits;
import com.flagsmith.MapperFactory;
import com.flagsmith.Trait;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.LoggerFactory;

public class FlagsmithClient {
    private FlagsmithConfig defaultConfig;
    private static final String AUTH_HEADER = "X-Environment-Key";
    private static final String ACCEPT_HEADER = "Accept";
    private String apiKey;
    private final FlagsmithLogger logger = new FlagsmithLogger();
    private HashMap<String, String> customHeaders;

    private FlagsmithClient() {
    }

    public List<Flag> getFeatureFlags() {
        return this.getFeatureFlags(null);
    }

    public List<Flag> getFeatureFlags(FeatureUser user) {
        HttpUrl.Builder urlBuilder = user == null ? this.defaultConfig.flagsURI.newBuilder().addEncodedQueryParameter("page", "1") : this.defaultConfig.flagsURI.newBuilder("").addEncodedPathSegment(user.getIdentifier());
        Request request = this.newRequestBuilder().url(urlBuilder.build()).build();
        Call call = this.defaultConfig.httpClient.newCall(request);
        ArrayList<Flag> featureFlags = new ArrayList();
        try (Response response = call.execute();){
            if (response.isSuccessful()) {
                ObjectMapper mapper = MapperFactory.getMappper();
                featureFlags = Arrays.asList((Object[])mapper.readValue(response.body().string(), Flag[].class));
            } else {
                this.logger.httpError(request, response);
            }
        }
        catch (IOException io) {
            this.logger.httpError(request, io);
        }
        this.logger.info("Got feature flags for user = {}, flags = {}", user, featureFlags);
        return featureFlags;
    }

    public boolean hasFeatureFlag(String featureId) {
        List<Flag> featureFlags = this.getFeatureFlags();
        return FlagsmithClient.hasFeatureFlagByName(featureId, featureFlags);
    }

    public boolean hasFeatureFlag(String featureId, FeatureUser user) {
        List<Flag> featureFlags = this.getFeatureFlags(user);
        return FlagsmithClient.hasFeatureFlagByName(featureId, featureFlags);
    }

    public static boolean hasFeatureFlag(String featureId, FlagsAndTraits flagsAndTraits) {
        if (flagsAndTraits == null) {
            return false;
        }
        return FlagsmithClient.hasFeatureFlagByName(featureId, flagsAndTraits.getFlags());
    }

    private static boolean hasFeatureFlagByName(String featureId, List<Flag> featureFlags) {
        if (featureFlags != null) {
            for (Flag flag : featureFlags) {
                if (!flag.getFeature().getName().equals(featureId) || !flag.isEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    public String getFeatureFlagValue(String featureId) {
        List<Flag> featureFlags = this.getFeatureFlags();
        return FlagsmithClient.getFeatureFlagValueByName(featureId, featureFlags);
    }

    public String getFeatureFlagValue(String featureId, FeatureUser user) {
        List<Flag> featureFlags = this.getFeatureFlags(user);
        return FlagsmithClient.getFeatureFlagValueByName(featureId, featureFlags);
    }

    public static String getFeatureFlagValue(String featureId, FlagsAndTraits flagsAndTraits) {
        if (flagsAndTraits == null) {
            return null;
        }
        return FlagsmithClient.getFeatureFlagValueByName(featureId, flagsAndTraits.getFlags());
    }

    private static String getFeatureFlagValueByName(String featureId, List<Flag> featureFlags) {
        if (featureFlags != null) {
            for (Flag flag : featureFlags) {
                if (!flag.getFeature().getName().equals(featureId)) continue;
                return flag.getStateValue();
            }
        }
        return null;
    }

    public Trait getTrait(FeatureUser user, String key) {
        List<Trait> traits = this.getUserTraits(user);
        return FlagsmithClient.getTraitByKey(key, traits);
    }

    public static Trait getTrait(FlagsAndTraits flagsAndTraits, String key) {
        if (flagsAndTraits == null) {
            return null;
        }
        return FlagsmithClient.getTraitByKey(key, flagsAndTraits.getTraits());
    }

    private static Trait getTraitByKey(String key, List<Trait> traits) {
        if (traits != null) {
            for (Trait trait : traits) {
                if (!trait.getKey().equals(key)) continue;
                return trait;
            }
        }
        return null;
    }

    public List<Trait> getTraits(FeatureUser user, String ... keys) {
        List<Trait> traits = this.getUserTraits(user);
        return FlagsmithClient.getTraitsByKeys(traits, keys);
    }

    public static List<Trait> getTraits(FlagsAndTraits flagsAndTraits, String ... keys) {
        if (flagsAndTraits == null) {
            return null;
        }
        return FlagsmithClient.getTraitsByKeys(flagsAndTraits.getTraits(), keys);
    }

    private static List<Trait> getTraitsByKeys(List<Trait> traits, String[] keys) {
        if (keys == null || keys.length == 0 || traits == null) {
            return traits;
        }
        ArrayList<Trait> filteredTraits = new ArrayList<Trait>();
        for (Trait trait : traits) {
            if (!Arrays.asList(keys).contains(trait.getKey())) continue;
            filteredTraits.add(trait);
        }
        return filteredTraits;
    }

    private List<Trait> getUserTraits(FeatureUser user) {
        return this.getUserFlagsAndTraits(user).getTraits();
    }

    public FlagsAndTraits getUserFlagsAndTraits(FeatureUser user) {
        HttpUrl url = this.defaultConfig.identitiesURI.newBuilder("").addEncodedQueryParameter("identifier", user.getIdentifier()).build();
        Request request = this.newRequestBuilder().url(url).build();
        Call call = this.defaultConfig.httpClient.newCall(request);
        FlagsAndTraits flagsAndTraits = new FlagsAndTraits();
        try (Response response = call.execute();){
            if (response.isSuccessful()) {
                ObjectMapper mapper = MapperFactory.getMappper();
                flagsAndTraits = (FlagsAndTraits)mapper.readValue(response.body().string(), FlagsAndTraits.class);
            } else {
                this.logger.httpError(request, response);
            }
        }
        catch (IOException io) {
            this.logger.httpError(request, io);
        }
        this.logger.info("Got feature flags & traits for user = {}, flagsAndTraits = {}", user, flagsAndTraits);
        return flagsAndTraits;
    }

    public Trait updateTrait(FeatureUser user, Trait toUpdate) {
        return this.postUserTraits(user, toUpdate);
    }

    public List<Trait> identifyUserWithTraits(FeatureUser user, List<Trait> traits) {
        HttpUrl url = this.defaultConfig.identitiesURI;
        if (user == null || user.getIdentifier() == null || user.getIdentifier().length() < 1) {
            throw new IllegalArgumentException("Missing user Identifier");
        }
        IdentityTraits identityTraits = new IdentityTraits();
        identityTraits.setIdentifier(user.getIdentifier());
        if (traits != null) {
            identityTraits.setTraits(traits);
        }
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)JSON, (String)identityTraits.toString());
        Request request = this.newRequestBuilder().post(body).url(url).build();
        ArrayList<Trait> traitsData = new ArrayList();
        Call call = this.defaultConfig.httpClient.newCall(request);
        try (Response response = call.execute();){
            if (response.isSuccessful()) {
                ObjectMapper mapper = MapperFactory.getMappper();
                FlagsAndTraits flagsAndTraits = (FlagsAndTraits)mapper.readValue(response.body().string(), FlagsAndTraits.class);
                traitsData = flagsAndTraits.getTraits();
            } else {
                this.logger.httpError(request, response);
            }
        }
        catch (IOException io) {
            this.logger.httpError(request, io);
        }
        this.logger.info("Got traits for user = {}, traits = {}", user, traitsData);
        return traitsData;
    }

    private Trait postUserTraits(FeatureUser user, Trait toUpdate) {
        HttpUrl url = this.defaultConfig.traitsURI;
        toUpdate.setIdentity(user);
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)JSON, (String)toUpdate.toString());
        Request request = this.newRequestBuilder().post(body).url(url).build();
        Trait trait = null;
        Call call = this.defaultConfig.httpClient.newCall(request);
        try (Response response = call.execute();){
            if (response.isSuccessful()) {
                ObjectMapper mapper = MapperFactory.getMappper();
                trait = (Trait)mapper.readValue(response.body().string(), Trait.class);
            } else {
                this.logger.httpError(request, response);
            }
        }
        catch (IOException io) {
            this.logger.httpError(request, io);
        }
        this.logger.info("Updated trait for user = {}, new trait = {}, updated trait = {}", user, toUpdate, trait);
        return trait;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private Request.Builder newRequestBuilder() {
        Request.Builder builder = new Request.Builder().header(AUTH_HEADER, this.apiKey).addHeader(ACCEPT_HEADER, "application/json");
        if (this.customHeaders != null && !this.customHeaders.isEmpty()) {
            this.customHeaders.forEach((k, v) -> builder.addHeader(k, v));
        }
        return builder;
    }

    public static class Builder {
        private FlagsmithClient client;
        private FlagsmithConfig configuration = FlagsmithConfig.newBuilder().build();

        private Builder() {
            this.client = new FlagsmithClient();
        }

        public Builder setApiKey(String apiKey) {
            if (null == apiKey) {
                throw new IllegalArgumentException("Api key can not be null");
            }
            this.client.apiKey = apiKey;
            return this;
        }

        public Builder enableLogging(FlagsmithLoggerLevel level) {
            this.client.logger.setLogger(LoggerFactory.getLogger(FlagsmithClient.class), level);
            return this;
        }

        public Builder enableLogging() {
            this.client.logger.setLogger(LoggerFactory.getLogger(FlagsmithClient.class));
            return this;
        }

        public Builder withConfiguration(FlagsmithConfig config) {
            if (config != null) {
                this.configuration = config;
            }
            return this;
        }

        public Builder withApiUrl(String apiUrl) {
            if (apiUrl != null) {
                this.configuration = FlagsmithConfig.newBuilder().baseURI(apiUrl).build();
            }
            return this;
        }

        public Builder withCustomHttpHeaders(HashMap<String, String> customHeaders) {
            this.client.customHeaders = customHeaders;
            return this;
        }

        public FlagsmithClient build() {
            this.client.defaultConfig = this.configuration;
            return this.client;
        }
    }
}

