/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import com.flagsmith.FeatureUser;
import com.flagsmith.FlagsAndTraits;
import com.flagsmith.FlagsmithAPIWrapper;
import com.flagsmith.FlagsmithCache;
import com.flagsmith.FlagsmithCacheConfig;
import com.flagsmith.FlagsmithSDK;
import com.flagsmith.Trait;
import java.util.List;

class FlagsmithCachedAPIWrapper
implements FlagsmithSDK {
    private final FlagsmithAPIWrapper flagsmithAPIWrapper;
    private final FlagsmithCacheConfig.FlagsmithInternalCache cache;

    public FlagsmithCachedAPIWrapper(FlagsmithCacheConfig.FlagsmithInternalCache cache, FlagsmithAPIWrapper flagsmithAPIWrapper) {
        this.cache = cache;
        this.flagsmithAPIWrapper = flagsmithAPIWrapper;
    }

    @Override
    public FlagsAndTraits getFeatureFlags(FeatureUser user, boolean doThrow) {
        if (user == null) {
            return this.flagsmithAPIWrapper.getFeatureFlags(null, doThrow);
        }
        this.assertValidUser(user);
        return (FlagsAndTraits)this.cache.getCache().get((Object)user.getIdentifier(), k -> this.flagsmithAPIWrapper.getFeatureFlags(user, doThrow));
    }

    @Override
    public FlagsAndTraits getUserFlagsAndTraits(FeatureUser user, boolean doThrow) {
        this.assertValidUser(user);
        return (FlagsAndTraits)this.cache.getCache().get((Object)user.getIdentifier(), k -> this.flagsmithAPIWrapper.getUserFlagsAndTraits(user, doThrow));
    }

    @Override
    public Trait postUserTraits(FeatureUser user, Trait toUpdate, boolean doThrow) {
        this.assertValidUser(user);
        FlagsAndTraits flagsAndTraits = (FlagsAndTraits)this.cache.getCache().getIfPresent((Object)user.getIdentifier());
        Trait newTrait = new Trait(null, toUpdate.getKey(), toUpdate.getValue());
        if (flagsAndTraits != null && flagsAndTraits.getTraits() != null && flagsAndTraits.getTraits().contains(newTrait)) {
            this.flagsmithAPIWrapper.getLogger().info("User trait unchanged for user {}, trait: {}", user.getIdentifier(), toUpdate);
            return toUpdate;
        }
        this.cache.getCache().invalidate((Object)user.getIdentifier());
        return this.flagsmithAPIWrapper.postUserTraits(user, toUpdate, doThrow);
    }

    @Override
    public FlagsAndTraits identifyUserWithTraits(FeatureUser user, List<Trait> traits, boolean doThrow) {
        this.assertValidUser(user);
        FlagsAndTraits flagsAndTraits = this.flagsmithAPIWrapper.identifyUserWithTraits(user, traits, doThrow);
        this.cache.getCache().put((Object)user.getIdentifier(), (Object)flagsAndTraits);
        return flagsAndTraits;
    }

    @Override
    public FlagsmithCache getCache() {
        return this.cache;
    }
}

