/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flagsmith.Feature;
import com.flagsmith.MapperFactory;
import java.io.IOException;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Flag
implements Serializable {
    private Feature feature;
    @JsonProperty(value="feature_state_value")
    private String stateValue;
    private boolean enabled;

    @JsonIgnore
    public void parse(String data) throws IOException {
        ObjectMapper mapper = MapperFactory.getMappper();
        Flag prototype = (Flag)mapper.readValue(data, Flag.class);
        this.fromPrototype(prototype);
    }

    @JsonIgnore
    private void fromPrototype(Flag prototype) {
        this.setFeature(prototype.getFeature());
        this.setStateValue(prototype.getStateValue());
        this.setEnabled(prototype.isEnabled());
    }

    @JsonIgnore
    public String toString() {
        ObjectMapper mapper = MapperFactory.getMappper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return super.toString();
        }
    }

    public Feature getFeature() {
        return this.feature;
    }

    public String getStateValue() {
        return this.stateValue;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    @JsonProperty(value="feature_state_value")
    public void setStateValue(String stateValue) {
        this.stateValue = stateValue;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flag)) {
            return false;
        }
        Flag other = (Flag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Feature this$feature = this.getFeature();
        Feature other$feature = other.getFeature();
        if (this$feature == null ? other$feature != null : !((Object)this$feature).equals(other$feature)) {
            return false;
        }
        String this$stateValue = this.getStateValue();
        String other$stateValue = other.getStateValue();
        return !(this$stateValue == null ? other$stateValue != null : !this$stateValue.equals(other$stateValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Flag;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Feature $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : ((Object)$feature).hashCode());
        String $stateValue = this.getStateValue();
        result = result * 59 + ($stateValue == null ? 43 : $stateValue.hashCode());
        return result;
    }
}

