/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flagsmith.FeatureUser;
import com.flagsmith.Flag;
import com.flagsmith.FlagsAndTraits;
import com.flagsmith.FlagsmithConfig;
import com.flagsmith.FlagsmithLogger;
import com.flagsmith.FlagsmithSDK;
import com.flagsmith.IdentityTraits;
import com.flagsmith.MapperFactory;
import com.flagsmith.Trait;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class FlagsmithAPIWrapper
implements FlagsmithSDK {
    private final FlagsmithLogger logger;
    private final FlagsmithConfig defaultConfig;
    private final HashMap<String, String> customHeaders;
    private static final String AUTH_HEADER = "X-Environment-Key";
    private static final String ACCEPT_HEADER = "Accept";
    private final String apiKey;

    public FlagsmithAPIWrapper(FlagsmithConfig defaultConfig, HashMap<String, String> customHeaders, FlagsmithLogger logger, String apiKey) {
        this.defaultConfig = defaultConfig;
        this.customHeaders = customHeaders;
        this.logger = logger;
        this.apiKey = apiKey;
    }

    @Override
    public FlagsAndTraits getFeatureFlags(FeatureUser user, boolean doThrow) {
        if (user != null) {
            return this.getUserFlagsAndTraits(user, doThrow);
        }
        HttpUrl.Builder urlBuilder = this.defaultConfig.flagsURI.newBuilder().addEncodedQueryParameter("page", "1");
        Request request = this.newRequestBuilder().url(urlBuilder.build()).build();
        Call call = this.defaultConfig.httpClient.newCall(request);
        FlagsAndTraits flagsAndTraits = this.newFlagsAndTraits();
        try (Response response = call.execute();){
            if (response.isSuccessful()) {
                ObjectMapper mapper = MapperFactory.getMappper();
                List<Object> featureFlags = Arrays.asList((Object[])mapper.readValue(response.body().string(), Flag[].class));
                flagsAndTraits.setFlags(featureFlags);
            } else {
                this.logger.httpError(request, response, doThrow);
            }
        }
        catch (IOException io) {
            this.logger.httpError(request, io, doThrow);
        }
        this.logger.info("Got feature flags for user = {}, flags = {}", user, flagsAndTraits);
        return flagsAndTraits;
    }

    @Override
    public FlagsAndTraits getUserFlagsAndTraits(FeatureUser user, boolean doThrow) {
        this.assertValidUser(user);
        HttpUrl url = this.defaultConfig.identitiesURI.newBuilder("").addEncodedQueryParameter("identifier", user.getIdentifier()).build();
        Request request = this.newRequestBuilder().url(url).build();
        Call call = this.defaultConfig.httpClient.newCall(request);
        FlagsAndTraits flagsAndTraits = this.newFlagsAndTraits();
        try (Response response = call.execute();){
            if (response.isSuccessful()) {
                ObjectMapper mapper = MapperFactory.getMappper();
                flagsAndTraits = (FlagsAndTraits)mapper.readValue(response.body().string(), FlagsAndTraits.class);
            } else {
                this.logger.httpError(request, response, doThrow);
            }
        }
        catch (IOException io) {
            this.logger.httpError(request, io, doThrow);
        }
        this.logger.info("Got feature flags & traits for user = {}, flagsAndTraits = {}", user, flagsAndTraits);
        return flagsAndTraits;
    }

    @Override
    public FlagsAndTraits identifyUserWithTraits(FeatureUser user, List<Trait> traits, boolean doThrow) {
        this.assertValidUser(user);
        HttpUrl url = this.defaultConfig.identitiesURI;
        IdentityTraits identityTraits = new IdentityTraits();
        identityTraits.setIdentifier(user.getIdentifier());
        if (traits != null) {
            identityTraits.setTraits(traits);
        }
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)JSON, (String)identityTraits.toString());
        Request request = this.newRequestBuilder().post(body).url(url).build();
        FlagsAndTraits flagsAndTraits = this.newFlagsAndTraits();
        Call call = this.defaultConfig.httpClient.newCall(request);
        try (Response response = call.execute();){
            if (response.isSuccessful()) {
                ObjectMapper mapper = MapperFactory.getMappper();
                flagsAndTraits = (FlagsAndTraits)mapper.readValue(response.body().string(), FlagsAndTraits.class);
            } else {
                this.logger.httpError(request, response, doThrow);
            }
        }
        catch (IOException io) {
            this.logger.httpError(request, io, doThrow);
        }
        this.logger.info("Got traits for user = {}, traits = {}", user, flagsAndTraits.getTraits());
        return flagsAndTraits;
    }

    @Override
    public Trait postUserTraits(FeatureUser user, Trait toUpdate, boolean doThrow) {
        HttpUrl url = this.defaultConfig.traitsURI;
        toUpdate.setIdentity(user);
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)JSON, (String)toUpdate.toString());
        Request request = this.newRequestBuilder().post(body).url(url).build();
        Trait trait = null;
        Call call = this.defaultConfig.httpClient.newCall(request);
        try (Response response = call.execute();){
            if (response.isSuccessful()) {
                ObjectMapper mapper = MapperFactory.getMappper();
                trait = (Trait)mapper.readValue(response.body().string(), Trait.class);
            } else {
                this.logger.httpError(request, response, doThrow);
            }
        }
        catch (IOException io) {
            this.logger.httpError(request, io, doThrow);
        }
        this.logger.info("Updated trait for user = {}, new trait = {}, updated trait = {}", user, toUpdate, trait);
        return trait;
    }

    public FlagsmithLogger getLogger() {
        return this.logger;
    }

    private Request.Builder newRequestBuilder() {
        Request.Builder builder = new Request.Builder().header(AUTH_HEADER, this.apiKey).addHeader(ACCEPT_HEADER, "application/json");
        if (this.customHeaders != null && !this.customHeaders.isEmpty()) {
            this.customHeaders.forEach((k, v) -> builder.addHeader(k, v));
        }
        return builder;
    }

    private FlagsAndTraits newFlagsAndTraits() {
        FlagsAndTraits flagsAndTraits = new FlagsAndTraits();
        flagsAndTraits.setFlags(new ArrayList<Flag>());
        flagsAndTraits.setTraits(new ArrayList<Trait>());
        return flagsAndTraits;
    }
}

